/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.scripting.janino.internal;

import net.thisptr.jmx.exporter.agent.misc.StringWriter;

public class LowerCaseWriter
implements StringWriter {
    private static final LowerCaseWriter INSTANCE = new LowerCaseWriter();

    public static LowerCaseWriter getInstance() {
        return INSTANCE;
    }

    @Override
    public int expectedSize(String name) {
        return name.length() + 1;
    }

    @Override
    public int write(String name, byte[] bytes, int index) {
        int savedIndex = index;
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                bytes[index++] = (byte)ch;
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                bytes[index++] = (byte)(ch + 32);
                continue;
            }
            if (ch == '_' || ch == ':') {
                bytes[index++] = (byte)ch;
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                if (savedIndex == index) {
                    bytes[index++] = 95;
                }
                bytes[index++] = (byte)ch;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                ++i;
            }
            bytes[index++] = 95;
        }
        if (savedIndex == index) {
            bytes[index++] = 95;
        }
        return index;
    }
}

