/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.scripting.janino;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import net.thisptr.jmx.exporter.agent.misc.Pair;
import net.thisptr.jmx.exporter.agent.scraper.Sample;
import net.thisptr.jmx.exporter.agent.scripting.ConditionScript;
import net.thisptr.jmx.exporter.agent.scripting.Declarations;
import net.thisptr.jmx.exporter.agent.scripting.PrometheusMetric;
import net.thisptr.jmx.exporter.agent.scripting.PrometheusMetricOutput;
import net.thisptr.jmx.exporter.agent.scripting.ScriptEngine;
import net.thisptr.jmx.exporter.agent.scripting.TransformScript;
import net.thisptr.jmx.exporter.agent.scripting.janino.api.AttributeValue;
import net.thisptr.jmx.exporter.agent.scripting.janino.api.MetricValue;
import net.thisptr.jmx.exporter.agent.scripting.janino.api.MetricValueOutput;
import net.thisptr.jmx.exporter.agent.scripting.janino.api._InternalUseDoNotImportProxyAccessor;
import net.thisptr.jmx.exporter.agent.scripting.janino.api.fn.LogFunction;
import net.thisptr.jmx.exporter.agent.scripting.janino.api.v1.V1;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.janino.ClassBodyEvaluator;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.janino.ExpressionEvaluator;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.janino.ScriptEvaluator;

public class JaninoScriptEngine
implements ScriptEngine {
    private static final String SCRIPT_HEADER = "import static " + LogFunction.class.getName() + ".*;";
    private static final String SCRIPT_FOOTER = ";";

    private static Pair<ClassLoader, StringBuilder> setupContext(List<Declarations> declarations) {
        ArrayList<String> staticImports = new ArrayList<String>();
        HashMap<String, byte[]> bytecodes = new HashMap<String, byte[]>();
        for (Declarations decl : declarations) {
            if (!(decl instanceof JaninoDeclarations)) continue;
            JaninoDeclarations janinoDecl = (JaninoDeclarations)decl;
            bytecodes.putAll(janinoDecl.bytecodes);
            staticImports.add(janinoDecl.topLevelClassName);
        }
        StaticBytecodeClassLoader classLoader = new StaticBytecodeClassLoader(JaninoScriptEngine.class.getClassLoader(), bytecodes);
        StringBuilder script = new StringBuilder();
        for (String staticImport : staticImports) {
            script.append(String.format("import static %s.*; ", staticImport));
        }
        return Pair.of(classLoader, script);
    }

    @Override
    public ConditionScript compileConditionScript(List<Declarations> declarations, String text, int ordinal) throws ScriptEngine.ScriptCompileException {
        try {
            Pair<ClassLoader, StringBuilder> context = JaninoScriptEngine.setupContext(declarations);
            StringBuilder script = (StringBuilder)context._2;
            script.append(text);
            ExpressionEvaluator ee = new ExpressionEvaluator();
            ee.setParentClassLoader((ClassLoader)context._1);
            ee.setClassName("sjmxe.Rule" + ordinal + "Condition");
            ConditionExpression expr = ee.createFastEvaluator(script.toString(), ConditionExpression.class, "mbeanInfo", "attributeInfo");
            return new ConditionScriptImpl(expr, script.toString());
        }
        catch (Exception e) {
            throw new ScriptEngine.ScriptCompileException(e);
        }
    }

    @Override
    public TransformScript compileTransformScript(List<Declarations> declarations, String text, int ordinal) throws ScriptEngine.ScriptCompileException {
        Pair<ClassLoader, StringBuilder> context = JaninoScriptEngine.setupContext(declarations);
        ScriptEvaluator se = new ScriptEvaluator();
        if (ordinal < 0) {
            se.setClassName("sjmxe.DefaultTransform");
        } else {
            se.setClassName("sjmxe.Rule" + ordinal + "Transform");
        }
        se.setDefaultImports(AttributeValue.class.getName(), MetricValue.class.getName(), MetricValueOutput.class.getName(), V1.class.getName());
        se.setParentClassLoader((ClassLoader)context._1);
        StringBuilder script = (StringBuilder)context._2;
        script.append(SCRIPT_HEADER);
        script.append(text);
        script.append(SCRIPT_FOOTER);
        try {
            Transformer compiledScript = (Transformer)se.createFastEvaluator(script.toString(), Transformer.class, new String[]{"in", "out", "match"});
            return new TransformScriptImpl(compiledScript);
        }
        catch (Exception e) {
            throw new ScriptEngine.ScriptCompileException(e);
        }
    }

    @Override
    public Declarations compileDeclarations(String text, int ordinal) throws ScriptEngine.ScriptCompileException {
        if (text == null) {
            return null;
        }
        ClassBodyEvaluator evaluator = new ClassBodyEvaluator();
        try {
            String topLevelClassName = "sjmxe.Declarations" + ordinal;
            evaluator.setClassName(topLevelClassName);
            evaluator.setDefaultImports(AttributeValue.class.getName(), MetricValue.class.getName(), MetricValueOutput.class.getName(), V1.class.getName());
            evaluator.cook(text);
            return new JaninoDeclarations(topLevelClassName, evaluator.getBytecodes());
        }
        catch (Exception e) {
            throw new ScriptEngine.ScriptCompileException(e);
        }
    }

    private class JaninoDeclarations
    implements Declarations {
        private final Map<String, byte[]> bytecodes;
        private final String topLevelClassName;

        public JaninoDeclarations(String topLevelClassName, Map<String, byte[]> bytesCodes) {
            this.topLevelClassName = topLevelClassName;
            this.bytecodes = bytesCodes;
        }
    }

    private static class StaticBytecodeClassLoader
    extends ClassLoader {
        private final Map<String, byte[]> bytecodes;

        public StaticBytecodeClassLoader(ClassLoader parent, Map<String, byte[]> bytecodes) {
            super(parent);
            this.bytecodes = bytecodes;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] bytecode = this.bytecodes.get(name);
            if (bytecode == null) {
                throw new ClassNotFoundException(name);
            }
            return this.defineClass(name, bytecode, 0, bytecode.length);
        }
    }

    private static class ConditionScriptImpl
    implements ConditionScript {
        private final ConditionExpression expr;
        private final String code;

        public ConditionScriptImpl(ConditionExpression expr, String code) {
            this.expr = expr;
            this.code = code;
        }

        @Override
        public boolean evaluate(MBeanInfo mbean, MBeanAttributeInfo attribute) {
            return this.expr.evaluate(mbean, attribute);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConditionScriptImpl other = (ConditionScriptImpl)obj;
            return !(this.code == null ? other.code != null : !this.code.equals(other.code));
        }
    }

    public static interface ConditionExpression {
        public boolean evaluate(MBeanInfo var1, MBeanAttributeInfo var2);
    }

    private static class TransformScriptImpl
    implements TransformScript {
        private final Transformer transformer;

        public TransformScriptImpl(Transformer transformer) {
            this.transformer = transformer;
        }

        @Override
        public void execute(Sample sample, PrometheusMetricOutput output) {
            AttributeValue in = new AttributeValue();
            in.attributeDescription = sample.attribute.getDescription();
            in.attributeName = sample.attribute.getName();
            in.attributeType = sample.attribute.getType();
            in.beanDescription = sample.info.getDescription();
            in.beanClass = sample.info.getClassName();
            in.domain = sample.name.domain();
            in.keyProperties = sample.name.keyProperties();
            in.timestamp = sample.timestamp;
            in.value = sample.value;
            try {
                this.transformer.transform(in, m3 -> {
                    PrometheusMetric metric = new PrometheusMetric();
                    metric.name = m3.name;
                    metric.labels = m3.labels;
                    metric.value = m3.value;
                    metric.timestamp = m3.timestamp;
                    metric.help = m3.help;
                    metric.type = m3.type;
                    metric.suffix = m3.suffix;
                    metric.nameWriter = _InternalUseDoNotImportProxyAccessor.getNameWriter(m3);
                    output.emit(metric);
                }, sample.captures);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface Transformer {
        public void transform(AttributeValue var1, MetricValueOutput var2, Map<String, String> var3) throws Exception;
    }
}

