/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.scripting;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.thisptr.jmx.exporter.agent.scripting.ScriptEngine;

public class ScriptEngineRegistry {
    private final Map<String, ScriptEngine> engines = new ConcurrentHashMap<String, ScriptEngine>();
    private static final ScriptEngineRegistry INSTANCE = new ScriptEngineRegistry();

    public static ScriptEngineRegistry getInstance() {
        return INSTANCE;
    }

    public void add(String name, ScriptEngine engine) {
        this.engines.put(name, engine);
    }

    public ScriptEngine get(String name) {
        ScriptEngine engine = this.engines.get(name);
        if (engine == null) {
            throw new IllegalArgumentException(String.format("\"%s\" is not registered", name));
        }
        return engine;
    }
}

