/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.misc;

import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.ObjectName;

public class FastObjectName {
    private final String domain;
    private final Map<String, String> keyProperties;
    private final ObjectName objectName;

    public FastObjectName(ObjectName objectName) {
        this.domain = objectName.getDomain();
        Hashtable<String, String> originalKeyProperties = objectName.getKeyPropertyList();
        LinkedHashMap keyProperties = new LinkedHashMap(originalKeyProperties.size());
        originalKeyProperties.forEach((k, v) -> {
            if (v.startsWith("\"")) {
                v = ObjectName.unquote(v);
            }
            keyProperties.put(k, v);
        });
        this.keyProperties = Collections.unmodifiableMap(keyProperties);
        this.objectName = objectName;
    }

    public String domain() {
        return this.domain;
    }

    public Map<String, String> keyProperties() {
        return this.keyProperties;
    }

    public ObjectName objectName() {
        return this.objectName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FastObjectName other = (FastObjectName)obj;
        return this.objectName.equals(other.objectName);
    }

    public int hashCode() {
        return this.objectName.hashCode();
    }

    public String toString() {
        return this.objectName.toString();
    }
}

