/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import net.thisptr.jmx.exporter.agent.config.ScriptText;
import net.thisptr.jmx.exporter.agent.config.deserializers.AttributeNamePatternDeserializer;
import net.thisptr.jmx.exporter.agent.config.deserializers.HostAndPortDeserializer;
import net.thisptr.jmx.exporter.agent.config.deserializers.ScriptTextDeserializer;
import net.thisptr.jmx.exporter.agent.config.validations.ValidScrapeRule;
import net.thisptr.jmx.exporter.agent.config.validations.ValidScrapeRuleList;
import net.thisptr.jmx.exporter.agent.misc.AttributeNamePattern;
import net.thisptr.jmx.exporter.agent.misc.Pair;
import net.thisptr.jmx.exporter.agent.scripting.ConditionScript;
import net.thisptr.jmx.exporter.agent.scripting.Declarations;
import net.thisptr.jmx.exporter.agent.scripting.ScriptEngine;
import net.thisptr.jmx.exporter.agent.scripting.ScriptEngineRegistry;
import net.thisptr.jmx.exporter.agent.scripting.TransformScript;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.annotation.JsonFormat;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.annotation.JsonProperty;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import net.thisptr.jmx.exporter.agent.shade.com.google.common.net.HostAndPort;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.Valid;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.constraints.Max;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.constraints.Min;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.constraints.NotNull;

@JsonDeserialize(builder=Builder.class)
public class Config {
    @Valid
    @NotNull
    @JsonProperty(value="server")
    public ServerConfig server = new ServerConfig();
    @Valid
    @NotNull
    @JsonProperty(value="options")
    public OptionsConfig options = new OptionsConfig();
    @NotNull
    @JsonProperty(value="declarations")
    public @NotNull List<@NotNull Declarations> declarations = new ArrayList<Declarations>();
    @NotNull
    @ValidScrapeRuleList
    @JsonProperty(value="rules")
    public @NotNull @ValidScrapeRuleList List<@Valid @ValidScrapeRule @NotNull ScrapeRule> rules = new ArrayList<ScrapeRule>();

    public static Config createDefault() {
        Config config = new Config();
        config.server.bindAddress = HostAndPort.fromString("0.0.0.0:9639");
        config.options.includeHelp = true;
        config.options.includeTimestamp = true;
        config.options.includeType = true;
        config.options.minimumResponseTime = 0L;
        ScrapeRule rule = new ScrapeRule();
        try {
            rule.transform = ScriptEngineRegistry.getInstance().get("java").compileTransformScript(Collections.emptyList(), "V1.transform(in, out, \"type\");", -1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        rule.patterns = Collections.emptyList();
        config.rules.add(rule);
        return config;
    }

    public static Config merge(List<Config> configs) {
        Config config = Config.createDefault();
        for (Config override : configs) {
            config.merge(override);
        }
        return config;
    }

    public void merge(Config other) {
        if (other.server != null && other.server.bindAddress != null) {
            this.server.bindAddress = other.server.bindAddress;
        }
        if (other.options != null) {
            if (other.options.includeHelp != null) {
                this.options.includeHelp = other.options.includeHelp;
            }
            if (other.options.includeTimestamp != null) {
                this.options.includeTimestamp = other.options.includeTimestamp;
            }
            if (other.options.includeType != null) {
                this.options.includeType = other.options.includeType;
            }
            if (other.options.minimumResponseTime != null) {
                this.options.minimumResponseTime = other.options.minimumResponseTime;
            }
        }
        if (other.declarations != null) {
            this.declarations.addAll(other.declarations);
        }
        if (other.rules != null && !other.rules.isEmpty()) {
            LinkedHashMap mergedRules = new LinkedHashMap();
            if (this.rules != null) {
                for (ScrapeRule rule : this.rules) {
                    mergedRules.put(Pair.of(rule.patterns != null ? rule.patterns : Collections.emptyList(), rule.condition), rule);
                }
            }
            for (ScrapeRule rule : other.rules) {
                mergedRules.put(Pair.of(rule.patterns != null ? rule.patterns : Collections.emptyList(), rule.condition), rule);
            }
            ScrapeRule defaultRule = (ScrapeRule)mergedRules.remove(Pair.of(Collections.emptyList(), null));
            this.rules = new ArrayList(mergedRules.values());
            this.rules.add(defaultRule);
        }
    }

    public static class ScrapeRule {
        @JsonProperty(value="pattern")
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        @JsonDeserialize(contentUsing=AttributeNamePatternDeserializer.class)
        public List<AttributeNamePattern> patterns;
        @JsonProperty(value="condition")
        public ConditionScript condition;
        @JsonProperty(value="skip")
        public boolean skip = false;
        @JsonProperty(value="transform")
        public TransformScript transform;
    }

    public static class OptionsConfig {
        @NotNull
        @JsonProperty(value="include_timestamp")
        public Boolean includeTimestamp;
        @NotNull
        @JsonProperty(value="include_help")
        public Boolean includeHelp;
        @NotNull
        @JsonProperty(value="include_type")
        public Boolean includeType;
        @Min(value=0L)
        @Max(value=60000L)
        @NotNull
        @JsonProperty(value="minimum_response_time")
        public @Min(value=0L) @Max(value=60000L) @NotNull Long minimumResponseTime;
    }

    public static class ServerConfig {
        @NotNull
        @JsonProperty(value="bind_address")
        @JsonDeserialize(using=HostAndPortDeserializer.class)
        public HostAndPort bindAddress;
    }

    @JsonPOJOBuilder
    public static class Builder {
        private List<ScriptText> declarations = new ArrayList<ScriptText>();
        private List<RuleSource> ruleSources = new ArrayList<RuleSource>();
        private OptionsConfig options = new OptionsConfig();
        private ServerConfig server = new ServerConfig();
        private static final String DEFAULT_ENGINE_NAME = "java";

        @JsonProperty(value="declarations")
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        @JsonDeserialize(contentUsing=ScriptTextDeserializer.class)
        public Builder withDeclarations(List<ScriptText> declarations) {
            this.declarations = declarations;
            return this;
        }

        @JsonProperty(value="rules")
        public Builder withRules(List<RuleSource> rules) {
            this.ruleSources = rules;
            return this;
        }

        @JsonProperty(value="options")
        public Builder withOptions(OptionsConfig options) {
            this.options = options;
            return this;
        }

        @JsonProperty(value="server")
        public Builder withServer(ServerConfig server) {
            this.server = server;
            return this;
        }

        public Config build() throws Exception {
            ScriptEngineRegistry registry = ScriptEngineRegistry.getInstance();
            ArrayList<Declarations> declarations = new ArrayList<Declarations>();
            for (int i = 0; i < this.declarations.size(); ++i) {
                ScriptText script = this.declarations.get(i);
                ScriptEngine scriptEngine = registry.get(script.engineName != null ? script.engineName : DEFAULT_ENGINE_NAME);
                declarations.add(scriptEngine.compileDeclarations(script.scriptBody, i));
            }
            ArrayList<ScrapeRule> rules = new ArrayList<ScrapeRule>();
            for (int i = 0; i < this.ruleSources.size(); ++i) {
                ScriptEngine scriptEngine;
                RuleSource ruleSource = this.ruleSources.get(i);
                ScrapeRule rule = new ScrapeRule();
                if (ruleSource.condition != null) {
                    scriptEngine = registry.get(ruleSource.condition.engineName != null ? ruleSource.condition.engineName : DEFAULT_ENGINE_NAME);
                    rule.condition = scriptEngine.compileConditionScript(declarations, ruleSource.condition.scriptBody, i);
                }
                if (ruleSource.transform != null) {
                    scriptEngine = registry.get(ruleSource.transform.engineName != null ? ruleSource.transform.engineName : DEFAULT_ENGINE_NAME);
                    rule.transform = scriptEngine.compileTransformScript(declarations, ruleSource.transform.scriptBody, i);
                }
                rule.skip = ruleSource.skip;
                rule.patterns = ruleSource.patterns;
                rules.add(rule);
            }
            Config config = new Config();
            config.server = this.server;
            config.options = this.options;
            config.declarations = declarations;
            config.rules = rules;
            return config;
        }

        public static class RuleSource {
            @JsonProperty(value="pattern")
            @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
            @JsonDeserialize(contentUsing=AttributeNamePatternDeserializer.class)
            public List<AttributeNamePattern> patterns;
            @JsonProperty(value="condition")
            @JsonDeserialize(using=ScriptTextDeserializer.class)
            public ScriptText condition;
            @JsonProperty(value="skip")
            public boolean skip = false;
            @JsonProperty(value="transform")
            @JsonDeserialize(using=ScriptTextDeserializer.class)
            public ScriptText transform;
        }
    }
}

