/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thisptr.jmx.exporter.agent.metrics.Instrumented;
import net.thisptr.jmx.exporter.agent.scripting.PrometheusMetric;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.annotation.JsonProperty;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BuildInfo
implements Instrumented {
    private static final Logger LOG = Logger.getLogger(BuildInfo.class.getName());
    @JsonProperty(value="git.build.time")
    public Date buildTime;
    @JsonProperty(value="git.build.version")
    public String buildVersion = "N/A";
    @JsonProperty(value="git.commit.time")
    public Date commitTime;
    @JsonProperty(value="git.commit.id")
    public String commitId = "N/A";
    private static final BuildInfo INSTANCE;

    public static BuildInfo getInstance() {
        return INSTANCE;
    }

    @Override
    public void toPrometheus(Consumer<PrometheusMetric> fn) {
        PrometheusMetric m3 = new PrometheusMetric();
        m3.value = 1.0;
        m3.name = "scriptable_jmx_exporter_build_info";
        m3.labels = new HashMap<String, String>();
        m3.labels.put("version", this.buildVersion);
        m3.labels.put("commit", this.commitId.substring(0, Math.min(7, this.commitId.length())));
        m3.help = "Version information of Scriptable JMX Exporter";
        fn.accept(m3);
    }

    static {
        BuildInfo info = null;
        try (InputStream is = BuildInfo.class.getClassLoader().getResourceAsStream("scriptable-jmx-exporter-git.json");){
            if (is != null) {
                info = new ObjectMapper().readValue(is, BuildInfo.class);
            } else {
                LOG.log(Level.WARNING, "Could not obtain build information. scriptable-jmx-exporter-git.json is missing.");
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Could not obtain build information.", e);
        }
        INSTANCE = info != null ? info : new BuildInfo();
    }
}

