/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.StandardProtocolFamily;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.net.CidrAddressTable;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Bits;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListeners;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ClosedWorkerException;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ManagementRegistration;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Option;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.OptionMap;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Options;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.StreamConnection;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioWorker;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.AcceptingChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.MulticastMessageChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.management.XnioServerMXBean;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.management.XnioWorkerMXBean;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.nio.Log;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.nio.NioTcpServer;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.nio.NioUdpChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.nio.NioXnio;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.nio.QueuedNioTcpServer2;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.nio.WorkerThread;

final class NioXnioWorker
extends XnioWorker {
    private static final int CLOSE_REQ = Integer.MIN_VALUE;
    private static final int CLOSE_COMP = 0x40000000;
    private final long workerStackSize;
    private volatile int state = 1;
    private final WorkerThread[] workerThreads;
    private final WorkerThread acceptThread;
    private final NioWorkerMetrics metrics;
    private volatile Thread shutdownWaiter;
    private static final AtomicReferenceFieldUpdater<NioXnioWorker, Thread> shutdownWaiterUpdater = AtomicReferenceFieldUpdater.newUpdater(NioXnioWorker.class, Thread.class, "shutdownWaiter");
    private static final AtomicIntegerFieldUpdater<NioXnioWorker> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(NioXnioWorker.class, "state");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NioXnioWorker(XnioWorker.Builder builder) {
        super(builder);
        NioXnio xnio = (NioXnio)builder.getXnio();
        int threadCount = builder.getWorkerIoThreads();
        this.workerStackSize = builder.getWorkerStackSize();
        String workerName = this.getName();
        WorkerThread[] workerThreads = new WorkerThread[threadCount];
        ThreadGroup threadGroup = builder.getThreadGroup();
        boolean markWorkerThreadAsDaemon = builder.isDaemon();
        boolean ok = false;
        try {
            Selector threadSelector;
            for (int i = 0; i < threadCount; ++i) {
                Selector threadSelector2;
                try {
                    threadSelector2 = xnio.mainSelectorCreator.open();
                }
                catch (IOException e) {
                    throw Log.log.unexpectedSelectorOpenProblem(e);
                }
                WorkerThread workerThread = new WorkerThread(this, threadSelector2, String.format("%s I/O-%d", workerName, i + 1), threadGroup, this.workerStackSize, i);
                if (markWorkerThreadAsDaemon) {
                    workerThread.setDaemon(true);
                }
                workerThreads[i] = workerThread;
            }
            try {
                threadSelector = xnio.mainSelectorCreator.open();
            }
            catch (IOException e) {
                throw Log.log.unexpectedSelectorOpenProblem(e);
            }
            this.acceptThread = new WorkerThread(this, threadSelector, String.format("%s Accept", workerName), threadGroup, this.workerStackSize, threadCount);
            if (markWorkerThreadAsDaemon) {
                this.acceptThread.setDaemon(true);
            }
            ok = true;
        }
        finally {
            if (!ok) {
                for (WorkerThread worker : workerThreads) {
                    if (worker == null) continue;
                    IoUtils.safeClose(worker.getSelector());
                }
            }
        }
        this.workerThreads = workerThreads;
        this.metrics = new NioWorkerMetrics(workerName);
        this.metrics.register();
    }

    void start() {
        for (WorkerThread worker : this.workerThreads) {
            this.openResourceUnconditionally();
            worker.start();
        }
        this.openResourceUnconditionally();
        this.acceptThread.start();
    }

    @Override
    protected CidrAddressTable<InetSocketAddress> getBindAddressTable() {
        return super.getBindAddressTable();
    }

    @Override
    protected WorkerThread chooseThread() {
        return this.getIoThread(ThreadLocalRandom.current().nextInt());
    }

    @Override
    public WorkerThread getIoThread(int hashCode) {
        WorkerThread[] workerThreads = this.workerThreads;
        int length = workerThreads.length;
        if (length == 0) {
            throw Log.log.noThreads();
        }
        if (length == 1) {
            return workerThreads[0];
        }
        return workerThreads[Math.abs(hashCode % length)];
    }

    @Override
    public int getIoThreadCount() {
        return this.workerThreads.length;
    }

    WorkerThread[] getAll() {
        return this.workerThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AcceptingChannel<StreamConnection> createTcpConnectionServer(InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<StreamConnection>> acceptListener, OptionMap optionMap) throws IOException {
        this.checkShutdown();
        boolean ok = false;
        ServerSocketChannel channel = ServerSocketChannel.open();
        try {
            if (optionMap.contains(Options.RECEIVE_BUFFER)) {
                channel.socket().setReceiveBufferSize(optionMap.get(Options.RECEIVE_BUFFER, -1));
            }
            channel.socket().setReuseAddress(optionMap.get(Options.REUSE_ADDRESSES, true));
            channel.configureBlocking(false);
            if (optionMap.contains(Options.BACKLOG)) {
                channel.socket().bind(bindAddress, optionMap.get(Options.BACKLOG, 128));
            } else {
                channel.socket().bind(bindAddress);
            }
            QueuedNioTcpServer2 server = new QueuedNioTcpServer2(new NioTcpServer(this, channel, optionMap, true));
            server.setAcceptListener((ChannelListener<? super QueuedNioTcpServer2>)acceptListener);
            ok = true;
            QueuedNioTcpServer2 queuedNioTcpServer2 = server;
            return queuedNioTcpServer2;
        }
        finally {
            if (!ok) {
                IoUtils.safeClose((Closeable)channel);
            }
        }
    }

    @Override
    public MulticastMessageChannel createUdpServer(InetSocketAddress bindAddress, ChannelListener<? super MulticastMessageChannel> bindListener, OptionMap optionMap) throws IOException {
        InetAddress address;
        this.checkShutdown();
        DatagramChannel channel = bindAddress != null ? ((address = bindAddress.getAddress()) instanceof Inet6Address ? DatagramChannel.open(StandardProtocolFamily.INET6) : DatagramChannel.open(StandardProtocolFamily.INET)) : DatagramChannel.open();
        channel.configureBlocking(false);
        if (optionMap.contains(Options.BROADCAST)) {
            channel.socket().setBroadcast(optionMap.get(Options.BROADCAST, false));
        }
        if (optionMap.contains(Options.IP_TRAFFIC_CLASS)) {
            channel.socket().setTrafficClass(optionMap.get(Options.IP_TRAFFIC_CLASS, -1));
        }
        if (optionMap.contains(Options.RECEIVE_BUFFER)) {
            channel.socket().setReceiveBufferSize(optionMap.get(Options.RECEIVE_BUFFER, -1));
        }
        channel.socket().setReuseAddress(optionMap.get(Options.REUSE_ADDRESSES, true));
        if (optionMap.contains(Options.SEND_BUFFER)) {
            channel.socket().setSendBufferSize(optionMap.get(Options.SEND_BUFFER, -1));
        }
        channel.socket().bind(bindAddress);
        NioUdpChannel udpChannel = new NioUdpChannel(this, channel);
        ChannelListeners.invokeChannelListener(udpChannel, bindListener);
        return udpChannel;
    }

    @Override
    public boolean isShutdown() {
        return (this.state & Integer.MIN_VALUE) != 0;
    }

    @Override
    public boolean isTerminated() {
        return (this.state & 0x40000000) != 0;
    }

    void openResourceUnconditionally() {
        int oldState = stateUpdater.getAndIncrement(this);
        if (Log.log.isTraceEnabled()) {
            Log.log.tracef("CAS %s %08x -> %08x", (Object)this, (Object)oldState, (Object)(oldState + 1));
        }
    }

    void checkShutdown() throws ClosedWorkerException {
        if (this.isShutdown()) {
            throw Log.log.workerShutDown();
        }
    }

    void closeResource() {
        int oldState = stateUpdater.decrementAndGet(this);
        if (Log.log.isTraceEnabled()) {
            Log.log.tracef("CAS %s %08x -> %08x", (Object)this, (Object)(oldState + 1), (Object)oldState);
        }
        while (oldState == Integer.MIN_VALUE) {
            if (stateUpdater.compareAndSet(this, Integer.MIN_VALUE, -1073741824)) {
                Log.log.tracef("CAS %s %08x -> %08x (close complete)", (Object)this, (Object)Integer.MIN_VALUE, (Object)-1073741824);
                NioXnioWorker.safeUnpark(shutdownWaiterUpdater.getAndSet(this, null));
                Runnable task = this.getTerminationTask();
                if (task != null) {
                    try {
                        task.run();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return;
            }
            oldState = this.state;
        }
    }

    @Override
    public void shutdown() {
        int oldState = this.state;
        while ((oldState & Integer.MIN_VALUE) == 0) {
            if (!stateUpdater.compareAndSet(this, oldState, oldState | Integer.MIN_VALUE)) {
                oldState = this.state;
                continue;
            }
            Log.log.tracef("Initiating shutdown of %s", (Object)this);
            for (WorkerThread worker : this.workerThreads) {
                worker.shutdown();
            }
            this.acceptThread.shutdown();
            this.shutDownTaskPool();
            return;
        }
        Log.log.tracef("Idempotent shutdown of %s", (Object)this);
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return this.shutDownTaskPoolNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        int oldState = this.state;
        if (Bits.allAreSet(oldState, 0x40000000)) {
            return true;
        }
        long then = System.nanoTime();
        long duration = unit.toNanos(timeout);
        Thread myThread = Thread.currentThread();
        while (Bits.allAreClear(oldState = this.state, 0x40000000)) {
            Thread oldThread = shutdownWaiterUpdater.getAndSet(this, myThread);
            try {
                oldState = this.state;
                if (Bits.allAreSet(oldState, 0x40000000)) break;
                LockSupport.parkNanos(this, duration);
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                long now = System.nanoTime();
                if ((duration -= now - then) >= 0L) continue;
                oldState = this.state;
                break;
            }
            finally {
                NioXnioWorker.safeUnpark(oldThread);
            }
        }
        return Bits.allAreSet(oldState, 0x40000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitTermination() throws InterruptedException {
        int oldState = this.state;
        if (Bits.allAreSet(oldState, 0x40000000)) {
            return;
        }
        Thread myThread = Thread.currentThread();
        while (Bits.allAreClear(this.state, 0x40000000)) {
            Thread oldThread = shutdownWaiterUpdater.getAndSet(this, myThread);
            try {
                if (!Bits.allAreSet(this.state, 0x40000000)) {
                    LockSupport.park(this);
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException();
                }
                break;
            }
            finally {
                NioXnioWorker.safeUnpark(oldThread);
            }
        }
    }

    private static void safeUnpark(Thread waiter) {
        if (waiter != null) {
            LockSupport.unpark(waiter);
        }
    }

    @Override
    protected void taskPoolTerminated() {
        IoUtils.safeClose((Closeable)this.metrics);
        this.closeResource();
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (option.equals(Options.WORKER_IO_THREADS)) {
            return option.cast(this.workerThreads.length);
        }
        if (option.equals(Options.STACK_SIZE)) {
            return option.cast(this.workerStackSize);
        }
        return super.getOption(option);
    }

    @Override
    public NioXnio getXnio() {
        return (NioXnio)super.getXnio();
    }

    WorkerThread getAcceptThread() {
        return this.acceptThread;
    }

    @Override
    public XnioWorkerMXBean getMXBean() {
        return this.metrics;
    }

    @Override
    protected ManagementRegistration registerServerMXBean(XnioServerMXBean serverMXBean) {
        return this.metrics.registerServerMXBean(serverMXBean);
    }

    private class NioWorkerMetrics
    implements XnioWorkerMXBean,
    Closeable {
        private final String workerName;
        private final CopyOnWriteArrayList<XnioServerMXBean> serverMetrics = new CopyOnWriteArrayList();
        private Closeable mbeanHandle;

        private NioWorkerMetrics(String workerName) {
            this.workerName = workerName;
        }

        @Override
        public String getProviderName() {
            return "nio";
        }

        @Override
        public String getName() {
            return this.workerName;
        }

        @Override
        public boolean isShutdownRequested() {
            return NioXnioWorker.this.isShutdown();
        }

        @Override
        public int getCoreWorkerPoolSize() {
            return NioXnioWorker.this.getCoreWorkerPoolSize();
        }

        @Override
        public int getMaxWorkerPoolSize() {
            return NioXnioWorker.this.getMaxWorkerPoolSize();
        }

        @Override
        public int getWorkerPoolSize() {
            return NioXnioWorker.this.getWorkerPoolSize();
        }

        @Override
        public int getBusyWorkerThreadCount() {
            return NioXnioWorker.this.getBusyWorkerThreadCount();
        }

        @Override
        public int getIoThreadCount() {
            return NioXnioWorker.this.getIoThreadCount();
        }

        @Override
        public int getWorkerQueueSize() {
            return NioXnioWorker.this.getWorkerQueueSize();
        }

        private ManagementRegistration registerServerMXBean(XnioServerMXBean serverMXBean) {
            this.serverMetrics.addIfAbsent(serverMXBean);
            Closeable handle = NioXnio.register(serverMXBean);
            return () -> {
                this.serverMetrics.remove(serverMXBean);
                IoUtils.safeClose(handle);
            };
        }

        @Override
        public Set<XnioServerMXBean> getServerMXBeans() {
            return new LinkedHashSet<XnioServerMXBean>(this.serverMetrics);
        }

        private void register() {
            this.mbeanHandle = NioXnio.register(this);
        }

        @Override
        public void close() throws IOException {
            IoUtils.safeClose(this.mbeanHandle);
            this.serverMetrics.clear();
        }
    }
}

