/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio._private.Messages;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSourceChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.AbstractStreamSinkConduit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.StreamSinkConduit;

public final class FixedLengthStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit>
implements StreamSinkConduit {
    private long remaining;

    public FixedLengthStreamSinkConduit(FixedLengthStreamSinkConduit next) {
        super(next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (count == 0L) {
            return 0L;
        }
        long remaining = this.remaining;
        if (remaining == 0L) {
            throw Messages.msg.fixedOverflow();
        }
        long res = 0L;
        try {
            long l = res = ((StreamSinkConduit)this.next).transferFrom(src, position, Math.min(count, remaining));
            return l;
        }
        finally {
            this.remaining = remaining - res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (count == 0L) {
            return 0L;
        }
        long remaining = this.remaining;
        if (remaining == 0L) {
            throw Messages.msg.fixedOverflow();
        }
        long res = 0L;
        try {
            long l = res = ((StreamSinkConduit)this.next).transferFrom(source, Math.min(count, remaining), throughBuffer);
            return l;
        }
        finally {
            this.remaining = remaining - res;
        }
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return this.write(src, true);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.write(srcs, offset, length, true);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.write(src, false);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        return this.write(srcs, offs, len, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int write(ByteBuffer src, boolean writeFinal) throws IOException {
        if (!src.hasRemaining()) {
            return 0;
        }
        int res = 0;
        long remaining = this.remaining;
        if (remaining == 0L) {
            throw Messages.msg.fixedOverflow();
        }
        try {
            int lim = src.limit();
            int pos = src.position();
            if ((long)(lim - pos) > remaining) {
                src.limit((int)(remaining - (long)pos));
                try {
                    int n = res = this.doWrite(src, writeFinal);
                    return n;
                }
                finally {
                    src.limit(lim);
                }
            }
            int n = res = this.doWrite(src, writeFinal);
            return n;
        }
        finally {
            this.remaining = remaining - (long)res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long write(ByteBuffer[] srcs, int offs, int len, boolean writeFinal) throws IOException {
        if (len == 0) {
            return 0L;
        }
        if (len == 1) {
            return this.write(srcs[offs], writeFinal);
        }
        long remaining = this.remaining;
        if (remaining == 0L) {
            throw Messages.msg.fixedOverflow();
        }
        long res = 0L;
        try {
            long t = 0L;
            for (int i = 0; i < len; ++i) {
                ByteBuffer buffer = srcs[i + offs];
                int lim = buffer.limit();
                if ((t += (long)(lim - buffer.position())) <= remaining) continue;
                buffer.limit(lim - (int)(t - remaining));
                try {
                    long l = res = this.doWrite(srcs, offs, i + 1, writeFinal);
                    return l;
                }
                finally {
                    buffer.limit(lim);
                }
            }
            if (t == 0L) {
                long l = 0L;
                return l;
            }
            long l = res = this.doWrite(srcs, offs, len, writeFinal);
            return l;
        }
        finally {
            this.remaining = remaining - res;
        }
    }

    private long doWrite(ByteBuffer[] srcs, int offs, int len, boolean writeFinal) throws IOException {
        if (writeFinal) {
            return ((StreamSinkConduit)this.next).writeFinal(srcs, offs, len);
        }
        return ((StreamSinkConduit)this.next).write(srcs, offs, len);
    }

    private int doWrite(ByteBuffer src, boolean writeFinal) throws IOException {
        if (writeFinal) {
            return ((StreamSinkConduit)this.next).writeFinal(src);
        }
        return ((StreamSinkConduit)this.next).write(src);
    }

    @Override
    public void terminateWrites() throws IOException {
        ((StreamSinkConduit)this.next).terminateWrites();
        if (this.remaining > 0L) {
            throw Messages.msg.fixedOverflow();
        }
    }

    @Override
    public void truncateWrites() throws IOException {
        ((StreamSinkConduit)this.next).terminateWrites();
        if (this.remaining > 0L) {
            throw Messages.msg.fixedOverflow();
        }
    }

    public long getRemaining() {
        return this.remaining;
    }
}

