/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Option;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioExecutor;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioIoThread;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioWorker;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.CloseListenerSettable;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.Configurable;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.ReadListenerSettable;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.ReadableMessageChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.MessageSourceConduit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.ReadReadyHandler;

public final class ConduitReadableMessageChannel
implements ReadableMessageChannel,
ReadListenerSettable<ConduitReadableMessageChannel>,
CloseListenerSettable<ConduitReadableMessageChannel>,
Cloneable {
    private final Configurable configurable;
    private MessageSourceConduit conduit;
    private ChannelListener<? super ConduitReadableMessageChannel> readListener;
    private ChannelListener<? super ConduitReadableMessageChannel> closeListener;

    public ConduitReadableMessageChannel(Configurable configurable, MessageSourceConduit conduit) {
        this.configurable = configurable;
        this.conduit = conduit;
        conduit.setReadReadyHandler(new ReadReadyHandler.ChannelListenerHandler<ConduitReadableMessageChannel>(this));
    }

    public MessageSourceConduit getConduit() {
        return this.conduit;
    }

    public void setConduit(MessageSourceConduit conduit) {
        this.conduit = conduit;
    }

    @Override
    public boolean isOpen() {
        return !this.conduit.isReadShutdown();
    }

    @Override
    public void setReadListener(ChannelListener<? super ConduitReadableMessageChannel> readListener) {
        this.readListener = readListener;
    }

    @Override
    public ChannelListener<? super ConduitReadableMessageChannel> getReadListener() {
        return this.readListener;
    }

    @Override
    public void setCloseListener(ChannelListener<? super ConduitReadableMessageChannel> closeListener) {
        this.closeListener = closeListener;
    }

    @Override
    public ChannelListener<? super ConduitReadableMessageChannel> getCloseListener() {
        return this.closeListener;
    }

    public ChannelListener.Setter<ConduitReadableMessageChannel> getReadSetter() {
        return new ReadListenerSettable.Setter<ConduitReadableMessageChannel>(this);
    }

    public ChannelListener.Setter<ConduitReadableMessageChannel> getCloseSetter() {
        return new CloseListenerSettable.Setter<ConduitReadableMessageChannel>(this);
    }

    @Override
    public XnioWorker getWorker() {
        return this.conduit.getWorker();
    }

    @Override
    public long receive(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.conduit.receive(dsts, offset, length);
    }

    @Override
    public long receive(ByteBuffer[] dsts) throws IOException {
        return this.conduit.receive(dsts, 0, dsts.length);
    }

    @Override
    public int receive(ByteBuffer dst) throws IOException {
        return this.conduit.receive(dst);
    }

    @Override
    public void suspendReads() {
        this.conduit.suspendReads();
    }

    @Override
    public void resumeReads() {
        this.conduit.resumeReads();
    }

    @Override
    public boolean isReadResumed() {
        return this.conduit.isReadResumed();
    }

    @Override
    public void wakeupReads() {
        this.conduit.wakeupReads();
    }

    @Override
    public void shutdownReads() throws IOException {
        this.conduit.terminateReads();
    }

    @Override
    public void awaitReadable() throws IOException {
        this.conduit.awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        this.conduit.awaitReadable(time, timeUnit);
    }

    @Override
    @Deprecated
    public XnioExecutor getReadThread() {
        return this.conduit.getReadThread();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.conduit.getReadThread();
    }

    @Override
    public void close() throws IOException {
        this.conduit.terminateReads();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.configurable.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.configurable.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.configurable.setOption(option, value);
    }

    public ConduitReadableMessageChannel clone() {
        try {
            return (ConduitReadableMessageChannel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

