/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.xnio;

import java.io.IOError;
import java.io.IOException;
import java.security.AccessController;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.client.config.ConfigXMLParseException;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.OptionMap;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Options;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Xnio;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioWorker;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioWorkerConfigurator;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioXmlParser;
import net.thisptr.jmx.exporter.agent.shade.org.xnio._private.Messages;

final class DefaultXnioWorkerHolder {
    static final XnioWorker INSTANCE = AccessController.doPrivileged(() -> {
        Xnio xnio = Xnio.getInstance();
        XnioWorker worker = null;
        try {
            worker = XnioXmlParser.parseWorker(xnio);
        }
        catch (IOException | ConfigXMLParseException e) {
            Messages.msg.trace("Failed to parse worker XML definition", e);
        }
        if (worker == null) {
            Iterator<XnioWorkerConfigurator> iterator = ServiceLoader.load(XnioWorkerConfigurator.class, DefaultXnioWorkerHolder.class.getClassLoader()).iterator();
            while (worker == null) {
                try {
                    if (!iterator.hasNext()) break;
                    XnioWorkerConfigurator configurator = iterator.next();
                    if (configurator == null) continue;
                    try {
                        worker = configurator.createWorker();
                    }
                    catch (IOException e) {
                        Messages.msg.trace("Failed to configure the default worker", e);
                    }
                }
                catch (ServiceConfigurationError e) {
                    Messages.msg.trace("Failed to configure a service", e);
                }
            }
        }
        if (worker == null) {
            try {
                worker = xnio.createWorker(OptionMap.create(Options.THREAD_DAEMON, Boolean.TRUE));
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        return worker;
    });

    DefaultXnioWorkerHolder() {
    }
}

