/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.xnio;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Bits;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Option;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioIoThread;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioWorker;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.CloseableChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.ConnectedChannel;

public abstract class Connection
implements CloseableChannel,
ConnectedChannel {
    protected final XnioIoThread thread;
    private volatile int state;
    private static final int FLAG_READ_CLOSED = 1;
    private static final int FLAG_WRITE_CLOSED = 2;
    private static final AtomicIntegerFieldUpdater<Connection> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(Connection.class, "state");

    protected Connection(XnioIoThread thread) {
        this.thread = thread;
    }

    private static <A extends SocketAddress> A castAddress(Class<A> type, SocketAddress address) {
        return (A)(type.isInstance(address) ? (SocketAddress)type.cast(address) : null);
    }

    @Override
    public final <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return Connection.castAddress(type, this.getPeerAddress());
    }

    @Override
    public final <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return Connection.castAddress(type, this.getLocalAddress());
    }

    @Override
    public final XnioWorker getWorker() {
        return this.thread.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.thread;
    }

    protected boolean readClosed() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet(oldVal = this.state, 1)) continue;
            return false;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 1));
        if (Bits.allAreSet(newVal, 3)) {
            try {
                this.closeAction();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.invokeCloseListener();
        }
        return true;
    }

    protected boolean writeClosed() {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet(oldVal = this.state, 2)) continue;
            return false;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 2));
        if (Bits.allAreSet(newVal, 3)) {
            try {
                this.closeAction();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.invokeCloseListener();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        int newVal;
        int oldVal;
        do {
            if (!Bits.allAreSet(oldVal = this.state, 3)) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldVal, newVal = oldVal | 1 | 2));
        try {
            this.closeAction();
        }
        finally {
            if (Bits.allAreClear(oldVal, 2)) {
                try {
                    this.notifyWriteClosed();
                }
                catch (Throwable throwable) {}
            }
            if (Bits.allAreClear(oldVal, 1)) {
                try {
                    this.notifyReadClosed();
                }
                catch (Throwable throwable) {}
            }
            this.invokeCloseListener();
        }
    }

    public boolean isReadShutdown() {
        return Bits.allAreSet(this.state, 1);
    }

    public boolean isWriteShutdown() {
        return Bits.allAreSet(this.state, 2);
    }

    @Override
    public boolean isOpen() {
        return Bits.anyAreClear(this.state, 3);
    }

    protected abstract void notifyWriteClosed();

    protected abstract void notifyReadClosed();

    abstract void invokeCloseListener();

    protected void closeAction() throws IOException {
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return false;
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return null;
    }
}

