/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.crypto.Mac;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.Assert;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.bytes.ByteStringBuilder;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.codec.Base32Alphabet;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.codec.Base64Alphabet;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.Base16EncodingCodePointIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.BiDirIntIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.BigEndianBase32EncodingIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.BigEndianBase64EncodingIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.ByteArrayIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.ByteBufferIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.ByteIteratorInputStream;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.ByteTableTranslatingByteIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.CodePointIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.ConcatByteIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.DelimitedByteIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.IndexIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.IntTableTranslatingByteIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.InterleavedByteArrayIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.Latin1DecodingIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.LimitedByteIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.LittleEndianBase32EncodingIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.LittleEndianBase64EncodingIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.Utf8DecodingIterator;

public abstract class ByteIterator
implements BiDirIntIterator,
IndexIterator {
    private static final int OP_BUFFER_SIZE = 8192;
    private static final ThreadLocal<byte[]> OP_BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[8192];
        }
    };
    private static final byte[] NO_BYTES = new byte[0];
    public static final ByteIterator EMPTY = new ByteArrayIterator(0, NO_BYTES, 0);

    ByteIterator() {
    }

    @Override
    public abstract boolean hasNext();

    @Override
    public abstract boolean hasPrevious();

    @Override
    public abstract int next() throws NoSuchElementException;

    @Override
    public abstract int peekNext() throws NoSuchElementException;

    @Override
    public abstract int previous() throws NoSuchElementException;

    @Override
    public abstract int peekPrevious() throws NoSuchElementException;

    @Override
    public abstract long getIndex();

    public int getBE16() throws NoSuchElementException {
        return this.next() << 8 | this.next();
    }

    public int getBE32() throws NoSuchElementException {
        return this.next() << 24 | this.next() << 16 | this.next() << 8 | this.next();
    }

    public long getBE64() throws NoSuchElementException {
        return (long)this.next() << 56 | (long)this.next() << 48 | (long)this.next() << 40 | (long)this.next() << 32 | (long)this.next() << 24 | (long)this.next() << 16 | (long)this.next() << 8 | (long)this.next();
    }

    public int getLE16() throws NoSuchElementException {
        return this.next() | this.next() << 8;
    }

    public int getLE32() throws NoSuchElementException {
        return this.next() | this.next() << 8 | this.next() << 16 | this.next() << 24;
    }

    public long getLE64() throws NoSuchElementException {
        return (long)this.next() | (long)this.next() << 8 | (long)this.next() << 16 | (long)this.next() << 24 | (long)this.next() << 32 | (long)this.next() << 40 | (long)this.next() << 48 | (long)this.next() << 56;
    }

    public int getPackedBE32() throws NoSuchElementException {
        int v = this.next();
        int t = 0;
        while ((v & 0x80) != 0) {
            t = t << 7 | v & 0x7F;
            v = this.next();
        }
        t = t << 7 | v;
        return t;
    }

    public long getPackedBE64() throws NoSuchElementException {
        int v = this.next();
        long t = 0L;
        while ((v & 0x80) != 0) {
            t = t << 7 | (long)(v & 0x7F);
            v = this.next();
        }
        t = t << 7 | (long)v;
        return t;
    }

    public ByteStringBuilder appendTo(ByteStringBuilder builder) {
        byte[] buffer = OP_BUFFER.get();
        int cnt = this.drain(buffer);
        while (cnt > 0) {
            builder.append(buffer, 0, cnt);
            cnt = this.drain(buffer);
        }
        return builder;
    }

    public void update(MessageDigest digest) {
        byte[] buffer = OP_BUFFER.get();
        int cnt = this.drain(buffer);
        while (cnt > 0) {
            digest.update(buffer, 0, cnt);
            cnt = this.drain(buffer);
        }
    }

    public ByteIterator doFinal(MessageDigest digest) {
        this.update(digest);
        return ByteIterator.ofBytes(digest.digest());
    }

    public void update(Mac mac) {
        byte[] buffer = OP_BUFFER.get();
        int cnt = this.drain(buffer);
        while (cnt > 0) {
            mac.update(buffer, 0, cnt);
            cnt = this.drain(buffer);
        }
    }

    public ByteIterator doFinal(Mac mac) {
        return ByteIterator.ofBytes(mac.doFinal(this.drain()));
    }

    public void update(Signature signature) throws SignatureException {
        byte[] buffer = OP_BUFFER.get();
        int cnt = this.drain(buffer);
        while (cnt > 0) {
            signature.update(buffer, 0, cnt);
            cnt = this.drain(buffer);
        }
        signature.update(this.drain());
    }

    public ByteIterator sign(Signature signature) throws SignatureException {
        this.update(signature);
        return ByteIterator.ofBytes(signature.sign());
    }

    public boolean verify(Signature signature) throws SignatureException {
        byte[] buffer = OP_BUFFER.get();
        int cnt = this.drain(buffer);
        while (cnt > 0) {
            signature.update(buffer, 0, cnt);
            cnt = this.drain(buffer);
        }
        return signature.verify(NO_BYTES);
    }

    public CodePointIterator base64Encode(Base64Alphabet alphabet, boolean addPadding) {
        if (alphabet.isLittleEndian()) {
            return new LittleEndianBase64EncodingIterator(this, addPadding, alphabet);
        }
        return new BigEndianBase64EncodingIterator(this, addPadding, alphabet);
    }

    public CodePointIterator base64Encode(Base64Alphabet alphabet) {
        return this.base64Encode(alphabet, true);
    }

    public CodePointIterator base64Encode() {
        return this.base64Encode(Base64Alphabet.STANDARD, true);
    }

    public CodePointIterator base32Encode(Base32Alphabet alphabet, boolean addPadding) {
        if (alphabet.isLittleEndian()) {
            return new LittleEndianBase32EncodingIterator(this, addPadding, alphabet);
        }
        return new BigEndianBase32EncodingIterator(this, addPadding, alphabet);
    }

    public CodePointIterator base32Encode(Base32Alphabet alphabet) {
        return this.base32Encode(alphabet, true);
    }

    public CodePointIterator base32Encode() {
        return this.base32Encode(Base32Alphabet.STANDARD, true);
    }

    public CodePointIterator hexEncode(boolean toUpperCase) {
        return new Base16EncodingCodePointIterator(this, toUpperCase);
    }

    public CodePointIterator hexEncode() {
        return this.hexEncode(false);
    }

    public CodePointIterator asUtf8String() {
        if (!this.hasNext()) {
            return CodePointIterator.EMPTY;
        }
        return new Utf8DecodingIterator(this);
    }

    public CodePointIterator asLatin1String() {
        if (!this.hasNext()) {
            return CodePointIterator.EMPTY;
        }
        return new Latin1DecodingIterator(this, this.getIndex());
    }

    public final boolean contentEquals(ByteIterator other) {
        Assert.checkNotNullParam("other", other);
        while (this.hasNext()) {
            if (!other.hasNext()) {
                return false;
            }
            if (this.next() == other.next()) continue;
            return false;
        }
        return !other.hasNext();
    }

    public final ByteIterator limitedTo(int size) {
        if (size <= 0 || !this.hasNext()) {
            return EMPTY;
        }
        return new LimitedByteIterator(this, size);
    }

    public final ByteIterator delimitedBy(int ... delims) {
        if (delims == null || delims.length == 0 || !this.hasNext()) {
            return EMPTY;
        }
        for (int delim : delims) {
            if (delim >= 0 && delim <= 255) continue;
            return EMPTY;
        }
        return new DelimitedByteIterator(this, delims);
    }

    public ByteIterator interleavedWith(byte[] table) {
        return new ByteTableTranslatingByteIterator(this, table);
    }

    public ByteIterator interleavedWith(int[] table) {
        return new IntTableTranslatingByteIterator(this, table);
    }

    public ByteArrayOutputStream drainTo(ByteArrayOutputStream stream) {
        while (this.hasNext()) {
            stream.write(this.next());
        }
        return stream;
    }

    public byte[] drain() {
        return this.drainTo(new ByteArrayOutputStream()).toByteArray();
    }

    public byte[] drain(int count) {
        if (count == 0) {
            return NO_BYTES;
        }
        byte[] b = new byte[count];
        int cnt = this.drain(b);
        return cnt == 0 ? NO_BYTES : (cnt < b.length ? Arrays.copyOf(b, cnt) : b);
    }

    public byte[] drainAll(int count) throws NoSuchElementException {
        if (count == 0) {
            return NO_BYTES;
        }
        byte[] b = new byte[count];
        int cnt = this.drain(b);
        if (cnt < b.length) {
            throw new NoSuchElementException();
        }
        return b;
    }

    public int drain(byte[] dst) {
        return this.drain(dst, 0, dst.length);
    }

    public int drain(byte[] dst, int offs, int len) {
        for (int i = 0; i < len; ++i) {
            if (!this.hasNext()) {
                return i;
            }
            dst[offs + i] = (byte)this.next();
        }
        return len;
    }

    public String drainToUtf8(int count) {
        return new String(this.drain(count), StandardCharsets.UTF_8);
    }

    public String drainToLatin1(int count) {
        return new String(this.drain(count), StandardCharsets.ISO_8859_1);
    }

    public static ByteIterator ofBytes(byte ... bytes) {
        Assert.checkNotNullParam("bytes", bytes);
        return ByteIterator.ofBytes(bytes, 0, bytes.length);
    }

    public static ByteIterator ofBytes(byte[] bytes, int offs, int len) {
        Assert.checkNotNullParam("bytes", bytes);
        if (len <= 0) {
            return EMPTY;
        }
        return new ByteArrayIterator(len, bytes, offs);
    }

    public static ByteIterator ofBytes(byte[] bytes, int offs, int len, int[] interleave) {
        Assert.checkNotNullParam("bytes", bytes);
        Assert.checkNotNullParam("interleave", interleave);
        if (len <= 0) {
            return EMPTY;
        }
        return new InterleavedByteArrayIterator(len, bytes, offs, interleave);
    }

    public static ByteIterator ofBytes(byte[] bytes, int[] interleave) {
        return ByteIterator.ofBytes(bytes, 0, bytes.length, interleave);
    }

    public static ByteIterator ofByteBuffer(ByteBuffer buffer) {
        Assert.checkNotNullParam("buffer", buffer);
        return new ByteBufferIterator(buffer);
    }

    public static ByteIterator ofIterators(ByteIterator ... iterators) {
        Assert.checkNotNullParam("iterators", iterators);
        if (iterators.length == 0) {
            return EMPTY;
        }
        if (iterators.length == 1) {
            return iterators[0];
        }
        return new ConcatByteIterator(iterators);
    }

    public final InputStream asInputStream() {
        return new ByteIteratorInputStream(this);
    }
}

