/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.jboss.logging;

import java.util.Collections;
import java.util.Map;
import net.thisptr.jmx.exporter.agent.shade.org.jboss.logging.AbstractLoggerProvider;
import net.thisptr.jmx.exporter.agent.shade.org.jboss.logging.Logger;
import net.thisptr.jmx.exporter.agent.shade.org.jboss.logging.LoggerProvider;
import net.thisptr.jmx.exporter.agent.shade.org.jboss.logging.Slf4jLocationAwareLogger;
import net.thisptr.jmx.exporter.agent.shade.org.jboss.logging.Slf4jLogger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.spi.LocationAwareLogger;

final class Slf4jLoggerProvider
extends AbstractLoggerProvider
implements LoggerProvider {
    Slf4jLoggerProvider() {
    }

    @Override
    public Logger getLogger(String name) {
        org.slf4j.Logger l = LoggerFactory.getLogger((String)name);
        try {
            return new Slf4jLocationAwareLogger(name, (LocationAwareLogger)l);
        }
        catch (Throwable throwable) {
            return new Slf4jLogger(name, l);
        }
    }

    @Override
    public void clearMdc() {
        MDC.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putMdc(String key, Object value) {
        try {
            String string = MDC.get((String)key);
            return string;
        }
        finally {
            if (value == null) {
                MDC.remove((String)key);
            } else {
                MDC.put((String)key, (String)String.valueOf(value));
            }
        }
    }

    @Override
    public Object getMdc(String key) {
        return MDC.get((String)key);
    }

    @Override
    public void removeMdc(String key) {
        MDC.remove((String)key);
    }

    @Override
    public Map<String, Object> getMdcMap() {
        Map map = MDC.getCopyOfContextMap();
        return map == null ? Collections.emptyMap() : map;
    }
}

