/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.constraintvalidation;

import java.util.List;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.ClockProvider;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.ConstraintValidatorContext;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.ElementKind;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.metadata.ConstraintDescriptor;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraintvalidation.HibernateCrossParameterConstraintValidatorContext;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorContextImpl;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.path.PathImpl;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.Contracts;

public class CrossParameterConstraintValidatorContextImpl
extends ConstraintValidatorContextImpl
implements HibernateCrossParameterConstraintValidatorContext {
    private final List<String> methodParameterNames;

    public CrossParameterConstraintValidatorContextImpl(List<String> methodParameterNames, ClockProvider clockProvider, PathImpl propertyPath, ConstraintDescriptor<?> constraintDescriptor, Object constraintValidatorPayload) {
        super(clockProvider, propertyPath, constraintDescriptor, constraintValidatorPayload);
        Contracts.assertTrue(propertyPath.getLeafNode().getKind() == ElementKind.CROSS_PARAMETER, "Context can only be used for corss parameter validation");
        this.methodParameterNames = methodParameterNames;
    }

    @Override
    public final ConstraintValidatorContext.ConstraintViolationBuilder buildConstraintViolationWithTemplate(String messageTemplate) {
        return new CrossParameterConstraintViolationBuilderImpl(this.methodParameterNames, messageTemplate, this.getCopyOfBasePath());
    }

    @Override
    public List<String> getMethodParameterNames() {
        return this.methodParameterNames;
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(HibernateCrossParameterConstraintValidatorContext.class)) {
            return type.cast(this);
        }
        return super.unwrap(type);
    }

    private class CrossParameterConstraintViolationBuilderImpl
    extends ConstraintValidatorContextImpl.ConstraintViolationBuilderImpl {
        private final List<String> methodParameterNames;

        private CrossParameterConstraintViolationBuilderImpl(List<String> methodParameterNames, String template, PathImpl path) {
            super(CrossParameterConstraintValidatorContextImpl.this, template, path);
            this.methodParameterNames = methodParameterNames;
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addParameterNode(int index) {
            this.dropLeafNode();
            this.propertyPath.addParameterNode(this.methodParameterNames.get(index), index);
            return new ConstraintValidatorContextImpl.NodeBuilder(CrossParameterConstraintValidatorContextImpl.this, this.messageTemplate, this.propertyPath);
        }

        private void dropLeafNode() {
            this.propertyPath = PathImpl.createCopyWithoutLeafNode(this.propertyPath);
        }
    }
}

