/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.constraintvalidators.bv.money;

import java.util.ArrayList;
import java.util.List;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.ConstraintValidator;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.ConstraintValidatorContext;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.Currency;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.CollectionHelper;

public class CurrencyValidatorForMonetaryAmount
implements ConstraintValidator<Currency, MonetaryAmount> {
    private List<CurrencyUnit> acceptedCurrencies;

    @Override
    public void initialize(Currency currency) {
        ArrayList<CurrencyUnit> acceptedCurrencies = new ArrayList<CurrencyUnit>();
        for (String currencyCode : currency.value()) {
            acceptedCurrencies.add(Monetary.getCurrency((String)currencyCode, (String[])new String[0]));
        }
        this.acceptedCurrencies = CollectionHelper.toImmutableList(acceptedCurrencies);
    }

    @Override
    public boolean isValid(MonetaryAmount value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        return this.acceptedCurrencies.contains(value.getCurrency());
    }
}

