/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.CompileException;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.ErrorHandler;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.ICompiler;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.WarningHandler;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.util.StringUtil;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.util.resource.DirectoryResourceCreator;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.util.resource.DirectoryResourceFinder;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.util.resource.FileResource;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.util.resource.PathResourceFinder;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.util.resource.Resource;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.util.resource.ResourceCreator;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.compiler.util.resource.ResourceFinder;
import net.thisptr.jmx.exporter.agent.shade.org.codehaus.commons.nullanalysis.Nullable;

public abstract class AbstractCompiler
implements ICompiler {
    protected ResourceFinder sourceFinder = ResourceFinder.EMPTY_RESOURCE_FINDER;
    protected ResourceFinder classFileFinder = ICompiler.FIND_NEXT_TO_SOURCE_FILE;
    protected ResourceCreator classFileCreator = ICompiler.CREATE_NEXT_TO_SOURCE_FILE;
    public Charset sourceCharset = Charset.defaultCharset();
    protected boolean debugSource;
    protected boolean debugLines;
    protected boolean debugVars;
    protected File[] extensionDirectories = StringUtil.parsePath(System.getProperty("java.ext.dirs", ""));
    protected File[] classPath = StringUtil.parsePath(System.getProperty("java.class.path"));
    @Nullable
    protected File[] bootClassPath = StringUtil.parseOptionalPath(System.getProperty("sun.boot.class.path"));
    @Nullable
    protected ErrorHandler compileErrorHandler;
    @Nullable
    protected WarningHandler warningHandler;

    @Override
    public void setSourceFinder(ResourceFinder sourceFinder) {
        this.sourceFinder = sourceFinder;
    }

    @Override
    public final void setClassFileFinder(ResourceFinder destination, boolean rebuild) {
        this.setClassFileFinder(rebuild ? ResourceFinder.EMPTY_RESOURCE_FINDER : destination);
    }

    @Override
    public void setClassFileFinder(ResourceFinder classFileFinder) {
        this.classFileFinder = classFileFinder;
    }

    @Override
    public final void setClassFileCreator(ResourceCreator classFileCreator) {
        this.classFileCreator = classFileCreator;
    }

    @Override
    public final boolean compile(File[] sourceFiles) throws CompileException, IOException {
        Resource[] sourceFileResources = new Resource[sourceFiles.length];
        for (int i = 0; i < sourceFiles.length; ++i) {
            sourceFileResources[i] = new FileResource(sourceFiles[i]);
        }
        this.compile(sourceFileResources);
        return true;
    }

    @Override
    public final void setEncoding(Charset encoding) {
        this.setSourceCharset(encoding);
    }

    @Override
    public void setSourceCharset(Charset charset) {
        this.sourceCharset = charset;
    }

    @Override
    public final void setCharacterEncoding(@Nullable String characterEncoding) {
        this.setSourceCharset(characterEncoding == null ? Charset.defaultCharset() : Charset.forName(characterEncoding));
    }

    @Override
    public void setDebugLines(boolean value) {
        this.debugLines = value;
    }

    @Override
    public void setDebugVars(boolean value) {
        this.debugVars = value;
    }

    @Override
    public void setDebugSource(boolean value) {
        this.debugSource = value;
    }

    @Override
    public void setSourcePath(File[] directoriesAndArchives) {
        this.setSourceFinder(new PathResourceFinder(directoriesAndArchives));
    }

    @Override
    public void setBootClassPath(File[] directoriesAndArchives) {
        if (this.bootClassPath == null) {
            throw new IllegalArgumentException("This JVM doese not support BOOTCLASSPATH; probably because it is 9+");
        }
        this.bootClassPath = directoriesAndArchives;
    }

    @Override
    public void setExtensionDirectories(File[] directories) {
        this.extensionDirectories = directories;
    }

    @Override
    public void setClassPath(File[] directoriesAndArchives) {
        this.classPath = directoriesAndArchives;
    }

    @Override
    public final void setDestinationDirectory(@Nullable File destinationDirectory, boolean rebuild) {
        if (destinationDirectory == ICompiler.NO_DESTINATION_DIRECTORY) {
            this.setClassFileCreator(ICompiler.CREATE_NEXT_TO_SOURCE_FILE);
            this.setClassFileFinder(ICompiler.FIND_NEXT_TO_SOURCE_FILE, rebuild);
        } else {
            assert (destinationDirectory != null);
            this.setClassFileCreator(new DirectoryResourceCreator(destinationDirectory));
            this.setClassFileFinder(new DirectoryResourceFinder(destinationDirectory), rebuild);
        }
    }

    @Override
    public void setCompileErrorHandler(@Nullable ErrorHandler compileErrorHandler) {
        this.compileErrorHandler = compileErrorHandler;
    }

    @Override
    public void setWarningHandler(@Nullable WarningHandler warningHandler) {
        this.warningHandler = warningHandler;
    }
}

