/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.net.ssl.SSLEngine;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowOptions;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.ByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.PooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.alpn.ALPNManager;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.alpn.ALPNProvider;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.ssl.SslConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.ssl.UndertowXnioSsl;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.AggregateConnectorStatistics;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ConnectorStatistics;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.DelegateOpenListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.OpenListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.XnioByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http.ALPNLimitingSSLEngine;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.OptionMap;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Pool;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.StreamConnection;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSourceChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.SslConnection;

public class AlpnOpenListener
implements ChannelListener<StreamConnection>,
OpenListener {
    public static final String REQUIRED_CIPHER = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";
    private static final Set<String> REQUIRED_PROTOCOLS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("TLSv1.2", "TLSv1.3")));
    private final ALPNManager alpnManager = ALPNManager.INSTANCE;
    private final ByteBufferPool bufferPool;
    private final Map<String, ListenerEntry> listeners = new HashMap<String, ListenerEntry>();
    private String[] protocols;
    private final String fallbackProtocol;
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;
    private volatile boolean statisticsEnabled;
    private volatile boolean providerLogged;
    private volatile boolean alpnFailLogged;

    public AlpnOpenListener(Pool<ByteBuffer> bufferPool, OptionMap undertowOptions, DelegateOpenListener httpListener) {
        this(bufferPool, undertowOptions, "http/1.1", httpListener);
    }

    public AlpnOpenListener(Pool<ByteBuffer> bufferPool, OptionMap undertowOptions) {
        this(bufferPool, undertowOptions, null, null);
    }

    public AlpnOpenListener(Pool<ByteBuffer> bufferPool, OptionMap undertowOptions, String fallbackProtocol, DelegateOpenListener fallbackListener) {
        this(new XnioByteBufferPool(bufferPool), undertowOptions, fallbackProtocol, fallbackListener);
    }

    public AlpnOpenListener(ByteBufferPool bufferPool, OptionMap undertowOptions, DelegateOpenListener httpListener) {
        this(bufferPool, undertowOptions, "http/1.1", httpListener);
    }

    public AlpnOpenListener(ByteBufferPool bufferPool) {
        this(bufferPool, OptionMap.EMPTY, null, null);
    }

    public AlpnOpenListener(ByteBufferPool bufferPool, OptionMap undertowOptions) {
        this(bufferPool, undertowOptions, null, null);
    }

    public AlpnOpenListener(ByteBufferPool bufferPool, OptionMap undertowOptions, String fallbackProtocol, DelegateOpenListener fallbackListener) {
        this.bufferPool = bufferPool;
        this.undertowOptions = undertowOptions;
        this.fallbackProtocol = fallbackProtocol;
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
        if (fallbackProtocol != null && fallbackListener != null) {
            this.addProtocol(fallbackProtocol, fallbackListener, 0);
        }
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
        for (Map.Entry<String, ListenerEntry> delegate : this.listeners.entrySet()) {
            delegate.getValue().listener.setRootHandler(rootHandler);
        }
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
        for (Map.Entry<String, ListenerEntry> delegate : this.listeners.entrySet()) {
            delegate.getValue().listener.setRootHandler(this.rootHandler);
        }
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public ConnectorStatistics getConnectorStatistics() {
        if (this.statisticsEnabled) {
            ArrayList<ConnectorStatistics> stats = new ArrayList<ConnectorStatistics>();
            for (Map.Entry<String, ListenerEntry> l : this.listeners.entrySet()) {
                ConnectorStatistics c = l.getValue().listener.getConnectorStatistics();
                if (c == null) continue;
                stats.add(c);
            }
            return new AggregateConnectorStatistics(stats.toArray(new ConnectorStatistics[stats.size()]));
        }
        return null;
    }

    @Override
    public void closeConnections() {
        for (Map.Entry<String, ListenerEntry> i : this.listeners.entrySet()) {
            i.getValue().listener.closeConnections();
        }
    }

    public AlpnOpenListener addProtocol(String name, DelegateOpenListener listener, int weight) {
        this.listeners.put(name, new ListenerEntry(listener, weight, name));
        ArrayList<ListenerEntry> list = new ArrayList<ListenerEntry>(this.listeners.values());
        Collections.sort(list);
        this.protocols = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.protocols[i] = ((ListenerEntry)list.get((int)i)).protocol;
        }
        return this;
    }

    @Override
    public void handleEvent(final StreamConnection channel) {
        if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_LOGGER.tracef("Opened connection with %s", (Object)channel.getPeerAddress());
        }
        SslConduit sslConduit = UndertowXnioSsl.getSslConduit((SslConnection)channel);
        SSLEngine originalSSlEngine = sslConduit.getSSLEngine();
        final CompletableFuture selectedALPNEngine = new CompletableFuture();
        this.alpnManager.registerEngineCallback(originalSSlEngine, new SSLConduitUpdater(sslConduit, new Function<SSLEngine, SSLEngine>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SSLEngine apply(SSLEngine engine) {
                ALPNProvider provider;
                if (!AlpnOpenListener.engineSupportsHTTP2(engine)) {
                    ListenerEntry listener;
                    if (!AlpnOpenListener.this.alpnFailLogged) {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            if (!AlpnOpenListener.this.alpnFailLogged) {
                                UndertowLogger.REQUEST_LOGGER.debugf("ALPN has been configured however %s is not present or TLS1.2 is not enabled, falling back to default protocol", (Object)AlpnOpenListener.REQUIRED_CIPHER);
                                AlpnOpenListener.this.alpnFailLogged = true;
                            }
                        }
                    }
                    if (AlpnOpenListener.this.fallbackProtocol != null && (listener = (ListenerEntry)AlpnOpenListener.this.listeners.get(AlpnOpenListener.this.fallbackProtocol)) != null) {
                        selectedALPNEngine.complete(null);
                        return engine;
                    }
                }
                if ((provider = AlpnOpenListener.this.alpnManager.getProvider(engine)) == null) {
                    ListenerEntry listener;
                    if (!AlpnOpenListener.this.providerLogged) {
                        1 var3_4 = this;
                        synchronized (var3_4) {
                            if (!AlpnOpenListener.this.providerLogged) {
                                UndertowLogger.REQUEST_LOGGER.debugf("ALPN has been configured however no provider could be found for engine %s for connector at %s", (Object)engine, (Object)channel.getLocalAddress());
                                AlpnOpenListener.this.providerLogged = true;
                            }
                        }
                    }
                    if (AlpnOpenListener.this.fallbackProtocol != null && (listener = (ListenerEntry)AlpnOpenListener.this.listeners.get(AlpnOpenListener.this.fallbackProtocol)) != null) {
                        selectedALPNEngine.complete(null);
                        return engine;
                    }
                    UndertowLogger.REQUEST_LOGGER.debugf("No ALPN provider available and no fallback defined", new Object[0]);
                    IoUtils.safeClose((Closeable)channel);
                    selectedALPNEngine.complete(null);
                    return engine;
                }
                if (!AlpnOpenListener.this.providerLogged) {
                    1 listener = this;
                    synchronized (listener) {
                        if (!AlpnOpenListener.this.providerLogged) {
                            UndertowLogger.REQUEST_LOGGER.debugf("Using ALPN provider %s for connector at %s", (Object)provider, (Object)channel.getLocalAddress());
                            AlpnOpenListener.this.providerLogged = true;
                        }
                    }
                }
                final SSLEngine newEngine = provider.setProtocols(engine, AlpnOpenListener.this.protocols);
                ALPNLimitingSSLEngine alpnLimitingSSLEngine = new ALPNLimitingSSLEngine(newEngine, new Runnable(){

                    @Override
                    public void run() {
                        provider.setProtocols(newEngine, new String[]{AlpnOpenListener.this.fallbackProtocol});
                    }
                });
                selectedALPNEngine.complete(new SelectedAlpn(newEngine, provider));
                return alpnLimitingSSLEngine;
            }
        }));
        AlpnConnectionListener potentialConnection = new AlpnConnectionListener(channel, selectedALPNEngine);
        channel.getSourceChannel().setReadListener(potentialConnection);
        potentialConnection.handleEvent(channel.getSourceChannel());
    }

    public static boolean engineSupportsHTTP2(SSLEngine engine) {
        String[] ciphers;
        String[] protcols = engine.getEnabledProtocols();
        boolean found = false;
        for (String proto : protcols) {
            if (!REQUIRED_PROTOCOLS.contains(proto)) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        for (String i : ciphers = engine.getEnabledCipherSuites()) {
            if (!i.equals(REQUIRED_CIPHER)) continue;
            return true;
        }
        return false;
    }

    static final class SSLConduitUpdater
    implements Function<SSLEngine, SSLEngine> {
        final SslConduit conduit;
        final Function<SSLEngine, SSLEngine> underlying;

        SSLConduitUpdater(SslConduit conduit, Function<SSLEngine, SSLEngine> underlying) {
            this.conduit = conduit;
            this.underlying = underlying;
        }

        @Override
        public SSLEngine apply(SSLEngine engine) {
            SSLEngine res = this.underlying.apply(engine);
            this.conduit.setSslEngine(res);
            return res;
        }
    }

    static final class SelectedAlpn {
        final SSLEngine engine;
        final ALPNProvider provider;

        SelectedAlpn(SSLEngine engine, ALPNProvider provider) {
            this.engine = engine;
            this.provider = provider;
        }
    }

    private class AlpnConnectionListener
    implements ChannelListener<StreamSourceChannel> {
        private final StreamConnection channel;
        private final CompletableFuture<SelectedAlpn> selectedAlpn;

        private AlpnConnectionListener(StreamConnection channel, CompletableFuture<SelectedAlpn> selectedAlpn) {
            this.channel = channel;
            this.selectedAlpn = selectedAlpn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleEvent(StreamSourceChannel source) {
            PooledByteBuffer buffer = AlpnOpenListener.this.bufferPool.allocate();
            boolean free = true;
            try {
                while (true) {
                    int res;
                    if ((res = this.channel.getSourceChannel().read(buffer.getBuffer())) == -1) {
                        IoUtils.safeClose((Closeable)this.channel);
                        return;
                    }
                    buffer.getBuffer().flip();
                    SelectedAlpn selectedAlpn = this.selectedAlpn.getNow(null);
                    String selected = selectedAlpn != null ? selectedAlpn.provider.getSelectedProtocol(selectedAlpn.engine) : null;
                    if (selected != null) {
                        DelegateOpenListener listener;
                        if (selected.isEmpty()) {
                            if (AlpnOpenListener.this.fallbackProtocol == null) {
                                UndertowLogger.REQUEST_IO_LOGGER.noALPNFallback(this.channel.getPeerAddress());
                                IoUtils.safeClose((Closeable)this.channel);
                                return;
                            }
                            listener = ((ListenerEntry)((AlpnOpenListener)AlpnOpenListener.this).listeners.get((Object)((AlpnOpenListener)AlpnOpenListener.this).fallbackProtocol)).listener;
                        } else {
                            listener = ((ListenerEntry)((AlpnOpenListener)AlpnOpenListener.this).listeners.get((Object)selected)).listener;
                        }
                        source.getReadSetter().set(null);
                        listener.handleEvent(this.channel, buffer);
                        free = false;
                        return;
                    }
                    if (res > 0) {
                        if (AlpnOpenListener.this.fallbackProtocol == null) {
                            UndertowLogger.REQUEST_IO_LOGGER.noALPNFallback(this.channel.getPeerAddress());
                            IoUtils.safeClose((Closeable)this.channel);
                            return;
                        }
                        DelegateOpenListener listener = ((ListenerEntry)((AlpnOpenListener)AlpnOpenListener.this).listeners.get((Object)((AlpnOpenListener)AlpnOpenListener.this).fallbackProtocol)).listener;
                        source.getReadSetter().set(null);
                        listener.handleEvent(this.channel, buffer);
                        free = false;
                        return;
                    }
                    if (res == 0) {
                        this.channel.getSourceChannel().resumeReads();
                        return;
                    }
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose((Closeable)this.channel);
                return;
            }
            catch (Throwable t) {
                UndertowLogger.REQUEST_IO_LOGGER.handleUnexpectedFailure(t);
                IoUtils.safeClose((Closeable)this.channel);
                return;
            }
            finally {
                if (free) {
                    buffer.close();
                }
            }
        }
    }

    private static class ListenerEntry
    implements Comparable<ListenerEntry> {
        final DelegateOpenListener listener;
        final int weight;
        final String protocol;

        ListenerEntry(DelegateOpenListener listener, int weight, String protocol) {
            this.listener = listener;
            this.weight = weight;
            this.protocol = protocol;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ListenerEntry)) {
                return false;
            }
            ListenerEntry that = (ListenerEntry)o;
            if (this.weight != that.weight) {
                return false;
            }
            if (!this.listener.equals(that.listener)) {
                return false;
            }
            return this.protocol.equals(that.protocol);
        }

        public int hashCode() {
            int result = this.listener.hashCode();
            result = 31 * result + this.weight;
            result = 31 * result + this.protocol.hashCode();
            return result;
        }

        @Override
        public int compareTo(ListenerEntry o) {
            return -Integer.compare(this.weight, o.weight);
        }
    }
}

