/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.proxy.mod_cluster;

import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ServerConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.proxy.ExclusivityChecker;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.proxy.ProxyCallback;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.proxy.ProxyClient;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.proxy.ProxyConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.proxy.mod_cluster.Context;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.proxy.mod_cluster.ModClusterContainer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.proxy.mod_cluster.ModClusterProxyTarget;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.AttachmentKey;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;

class ModClusterProxyClient
implements ProxyClient {
    private final AttachmentKey<ExclusiveConnectionHolder> exclusiveConnectionKey = AttachmentKey.create(ExclusiveConnectionHolder.class);
    private final ExclusivityChecker exclusivityChecker;
    private final ModClusterContainer container;

    protected ModClusterProxyClient(ExclusivityChecker exclusivityChecker, ModClusterContainer container) {
        this.exclusivityChecker = exclusivityChecker;
        this.container = container;
    }

    @Override
    public ProxyClient.ProxyTarget findTarget(HttpServerExchange exchange) {
        return this.container.findTarget(exchange);
    }

    @Override
    public void getConnection(ProxyClient.ProxyTarget target, HttpServerExchange exchange, final ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit) {
        final ExclusiveConnectionHolder holder = exchange.getConnection().getAttachment(this.exclusiveConnectionKey);
        if (holder != null && holder.connection.getConnection().isOpen()) {
            callback.completed(exchange, holder.connection);
            return;
        }
        if (!(target instanceof ModClusterProxyTarget)) {
            callback.couldNotResolveBackend(exchange);
            return;
        }
        ModClusterProxyTarget proxyTarget = (ModClusterProxyTarget)target;
        Context context = proxyTarget.resolveContext(exchange);
        if (context == null) {
            callback.couldNotResolveBackend(exchange);
        } else if (holder != null || this.exclusivityChecker != null && this.exclusivityChecker.isExclusivityRequired(exchange)) {
            ProxyCallback<ProxyConnection> wrappedCallback = new ProxyCallback<ProxyConnection>(){

                @Override
                public void completed(HttpServerExchange exchange, ProxyConnection result) {
                    if (holder != null) {
                        holder.connection = result;
                    } else {
                        final ExclusiveConnectionHolder newHolder = new ExclusiveConnectionHolder();
                        newHolder.connection = result;
                        ServerConnection connection = exchange.getConnection();
                        connection.putAttachment(ModClusterProxyClient.this.exclusiveConnectionKey, newHolder);
                        connection.addCloseListener(new ServerConnection.CloseListener(){

                            @Override
                            public void closed(ServerConnection connection) {
                                ClientConnection clientConnection = newHolder.connection.getConnection();
                                if (clientConnection.isOpen()) {
                                    IoUtils.safeClose((Closeable)clientConnection);
                                }
                            }
                        });
                    }
                    callback.completed(exchange, result);
                }

                @Override
                public void queuedRequestFailed(HttpServerExchange exchange) {
                    callback.queuedRequestFailed(exchange);
                }

                @Override
                public void failed(HttpServerExchange exchange) {
                    callback.failed(exchange);
                }

                @Override
                public void couldNotResolveBackend(HttpServerExchange exchange) {
                    callback.couldNotResolveBackend(exchange);
                }
            };
            context.handleRequest(proxyTarget, exchange, wrappedCallback, timeout, timeUnit, true);
        } else {
            context.handleRequest(proxyTarget, exchange, callback, timeout, timeUnit, false);
        }
    }

    private static class ExclusiveConnectionHolder {
        private ProxyConnection connection;

        private ExclusiveConnectionHolder() {
        }
    }
}

