/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HandlerWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.SecureCookieCommitListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.builder.HandlerBuilder;

public class SecureCookieHandler
implements HttpHandler {
    public static final HandlerWrapper WRAPPER = new HandlerWrapper(){

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new SecureCookieHandler(handler);
        }
    };
    private final HttpHandler next;

    public SecureCookieHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isSecure()) {
            exchange.addResponseCommitListener(SecureCookieCommitListener.INSTANCE);
        }
        this.next.handleRequest(exchange);
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "secure-cookie";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return WRAPPER;
        }
    }
}

