/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HandlerWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.builder.HandlerBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.CanonicalPathUtils;

public class PathSeparatorHandler
implements HttpHandler {
    private final HttpHandler next;

    public PathSeparatorHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        boolean handlingRequired;
        boolean bl = handlingRequired = File.separatorChar != '/';
        if (handlingRequired) {
            exchange.setRequestPath(CanonicalPathUtils.canonicalize(exchange.getRequestPath().replace(File.separatorChar, '/')));
            exchange.setRelativePath(CanonicalPathUtils.canonicalize(exchange.getRelativePath().replace(File.separatorChar, '/')));
            exchange.setResolvedPath(CanonicalPathUtils.canonicalize(exchange.getResolvedPath().replace(File.separatorChar, '/')));
        }
        this.next.handleRequest(exchange);
    }

    private static class Wrapper
    implements HandlerWrapper {
        private Wrapper() {
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new PathSeparatorHandler(handler);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "path-separator";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper();
        }
    }
}

