/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HandlerWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.builder.HandlerBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HeaderValues;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Methods;

public class HttpTraceHandler
implements HttpHandler {
    private final HttpHandler handler;

    public HttpTraceHandler(HttpHandler handler) {
        this.handler = handler;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.getRequestMethod().equals(Methods.TRACE)) {
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "message/http");
            StringBuilder body = new StringBuilder("TRACE ");
            body.append(exchange.getRequestURI());
            if (!exchange.getQueryString().isEmpty()) {
                body.append('?');
                body.append(exchange.getQueryString());
            }
            body.append(' ');
            body.append(exchange.getProtocol().toString());
            body.append("\r\n");
            for (HeaderValues header : exchange.getRequestHeaders()) {
                for (String value : header) {
                    body.append(header.getHeaderName());
                    body.append(": ");
                    body.append(value);
                    body.append("\r\n");
                }
            }
            body.append("\r\n");
            exchange.getResponseSender().send(body.toString());
        } else {
            this.handler.handleRequest(exchange);
        }
    }

    private static class Wrapper
    implements HandlerWrapper {
        private Wrapper() {
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new HttpTraceHandler(handler);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "trace";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper();
        }
    }
}

