/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.Handlers;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpUpgradeListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.HttpUpgradeHandshake;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.ResponseCodeHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.CopyOnWriteMap;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HeaderValues;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Methods;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListeners;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.StreamConnection;

public final class ChannelUpgradeHandler
implements HttpHandler {
    private final CopyOnWriteMap<String, List<Holder>> handlers = new CopyOnWriteMap();
    private volatile HttpHandler nonUpgradeHandler = ResponseCodeHandler.HANDLE_404;

    public synchronized void addProtocol(String productString, ChannelListener<? super StreamConnection> openListener, HttpUpgradeHandshake handshake) {
        this.addProtocol(productString, null, openListener, handshake);
    }

    public synchronized void addProtocol(String productString, HttpUpgradeListener openListener, HttpUpgradeHandshake handshake) {
        this.addProtocol(productString, openListener, null, handshake);
    }

    private synchronized void addProtocol(String productString, HttpUpgradeListener openListener, final ChannelListener<? super StreamConnection> channelListener, HttpUpgradeHandshake handshake) {
        List<Holder> list;
        if (productString == null) {
            throw new IllegalArgumentException("productString is null");
        }
        if (openListener == null && channelListener == null) {
            throw new IllegalArgumentException("openListener is null");
        }
        if (openListener == null) {
            openListener = new HttpUpgradeListener(){

                @Override
                public void handleUpgrade(StreamConnection streamConnection, HttpServerExchange exchange) {
                    ChannelListeners.invokeChannelListener(streamConnection, channelListener);
                }
            };
        }
        if ((list = this.handlers.get(productString)) == null) {
            list = new CopyOnWriteArrayList<Holder>();
            this.handlers.put(productString, list);
        }
        list.add(new Holder(openListener, handshake, channelListener));
    }

    public void addProtocol(String productString, ChannelListener<? super StreamConnection> openListener) {
        this.addProtocol(productString, openListener, null);
    }

    public void addProtocol(String productString, HttpUpgradeListener openListener) {
        this.addProtocol(productString, openListener, null);
    }

    public synchronized void removeProtocol(String productString) {
        this.handlers.remove(productString);
    }

    public synchronized void removeProtocol(String productString, ChannelListener<? super StreamConnection> openListener) {
        List<Holder> holders = this.handlers.get(productString);
        if (holders == null) {
            return;
        }
        for (Holder holder : holders) {
            if (holder.channelListener != openListener) continue;
            holders.remove(holder);
            break;
        }
        if (holders.isEmpty()) {
            this.handlers.remove(productString);
        }
    }

    public synchronized void removeProtocol(String productString, HttpUpgradeListener upgradeListener) {
        List<Holder> holders = this.handlers.get(productString);
        if (holders == null) {
            return;
        }
        for (Holder holder : holders) {
            if (holder.listener != upgradeListener) continue;
            holders.remove(holder);
            break;
        }
        if (holders.isEmpty()) {
            this.handlers.remove(productString);
        }
    }

    public HttpHandler getNonUpgradeHandler() {
        return this.nonUpgradeHandler;
    }

    public ChannelUpgradeHandler setNonUpgradeHandler(HttpHandler nonUpgradeHandler) {
        Handlers.handlerNotNull(nonUpgradeHandler);
        this.nonUpgradeHandler = nonUpgradeHandler;
        return this;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HeaderValues upgradeStrings = exchange.getRequestHeaders().get(Headers.UPGRADE);
        if (upgradeStrings != null && exchange.getRequestMethod().equals(Methods.GET)) {
            for (String string : upgradeStrings) {
                List<Holder> holders = this.handlers.get(string);
                if (holders == null) continue;
                for (Holder holder : holders) {
                    HttpUpgradeListener listener = holder.listener;
                    if (holder.handshake != null && !holder.handshake.handleUpgrade(exchange)) continue;
                    exchange.upgradeChannel(string, listener);
                    exchange.endExchange();
                    return;
                }
            }
        }
        this.nonUpgradeHandler.handleRequest(exchange);
    }

    private static final class Holder {
        final HttpUpgradeListener listener;
        final HttpUpgradeHandshake handshake;
        final ChannelListener<? super StreamConnection> channelListener;

        private Holder(HttpUpgradeListener listener, HttpUpgradeHandshake handshake, ChannelListener<? super StreamConnection> channelListener) {
            this.listener = listener;
            this.handshake = handshake;
            this.channelListener = channelListener;
        }
    }
}

