/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server;

import java.nio.ByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.ByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.PooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.DefaultByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Pool;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Pooled;

public class XnioByteBufferPool
implements ByteBufferPool {
    private final Pool<ByteBuffer> pool;
    private final ByteBufferPool arrayBackedPool;
    private final int bufferSize;
    private final boolean direct;

    public XnioByteBufferPool(Pool<ByteBuffer> pool) {
        this.pool = pool;
        Pooled<ByteBuffer> buf = pool.allocate();
        this.bufferSize = buf.getResource().remaining();
        this.direct = !buf.getResource().hasArray();
        buf.free();
        this.arrayBackedPool = this.direct ? new DefaultByteBufferPool(false, this.bufferSize) : this;
    }

    @Override
    public PooledByteBuffer allocate() {
        final Pooled<ByteBuffer> buf = this.pool.allocate();
        return new PooledByteBuffer(){
            private boolean open = true;

            @Override
            public ByteBuffer getBuffer() {
                return (ByteBuffer)buf.getResource();
            }

            @Override
            public void close() {
                this.open = false;
                buf.free();
            }

            @Override
            public boolean isOpen() {
                return this.open;
            }
        };
    }

    @Override
    public ByteBufferPool getArrayBackedPool() {
        return this.arrayBackedPool;
    }

    @Override
    public void close() {
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public boolean isDirect() {
        return this.direct;
    }
}

