/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.security.impl;

import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.security.api.NotificationReceiver;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.security.api.SecurityContext;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.security.api.SecurityNotification;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.security.idm.Account;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;

public abstract class AbstractSecurityContext
implements SecurityContext {
    private boolean authenticationRequired;
    protected final HttpServerExchange exchange;
    private Node<NotificationReceiver> notificationReceivers = null;
    private Account account;
    private String mechanismName;

    protected AbstractSecurityContext(HttpServerExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public void setAuthenticationRequired() {
        this.authenticationRequired = true;
    }

    @Override
    public boolean isAuthenticationRequired() {
        return this.authenticationRequired;
    }

    @Override
    public boolean isAuthenticated() {
        return this.account != null;
    }

    @Override
    public Account getAuthenticatedAccount() {
        return this.account;
    }

    @Override
    public String getMechanismName() {
        return this.mechanismName;
    }

    @Override
    public void authenticationComplete(Account account, String mechanism, boolean cachingRequired) {
        this.authenticationComplete(account, mechanism, false, cachingRequired);
    }

    protected void authenticationComplete(Account account, String mechanism, boolean programatic, boolean cachingRequired) {
        this.account = account;
        this.mechanismName = mechanism;
        UndertowLogger.SECURITY_LOGGER.debugf("Authenticated as %s, roles %s", (Object)account.getPrincipal().getName(), (Object)account.getRoles());
        this.sendNoticiation(new SecurityNotification(this.exchange, SecurityNotification.EventType.AUTHENTICATED, account, mechanism, programatic, UndertowMessages.MESSAGES.userAuthenticated(account.getPrincipal().getName()), cachingRequired));
    }

    @Override
    public void authenticationFailed(String message, String mechanism) {
        UndertowLogger.SECURITY_LOGGER.debugf("Authentication failed with message %s and mechanism %s for %s", (Object)message, (Object)mechanism, (Object)this.exchange);
        this.sendNoticiation(new SecurityNotification(this.exchange, SecurityNotification.EventType.FAILED_AUTHENTICATION, null, mechanism, false, message, true));
    }

    @Override
    public void registerNotificationReceiver(NotificationReceiver receiver) {
        if (this.notificationReceivers == null) {
            this.notificationReceivers = new Node(receiver);
        } else {
            Node<NotificationReceiver> cur = this.notificationReceivers;
            while (cur.next != null) {
                cur = cur.next;
            }
            cur.next = new Node(receiver);
        }
    }

    @Override
    public void removeNotificationReceiver(NotificationReceiver receiver) {
        Node<NotificationReceiver> cur = this.notificationReceivers;
        if (receiver.equals(cur.item)) {
            this.notificationReceivers = cur.next;
        } else {
            Node<NotificationReceiver> old = cur;
            while (cur.next != null) {
                cur = cur.next;
                if (receiver.equals(cur.item)) {
                    old.next = cur.next;
                }
                old = cur;
            }
        }
    }

    private void sendNoticiation(SecurityNotification notification) {
        Node<NotificationReceiver> cur = this.notificationReceivers;
        while (cur != null) {
            ((NotificationReceiver)cur.item).handleNotification(notification);
            cur = cur.next;
        }
    }

    @Override
    public void logout() {
        if (!this.isAuthenticated()) {
            return;
        }
        UndertowLogger.SECURITY_LOGGER.debugf("Logged out %s", (Object)this.exchange);
        this.sendNoticiation(new SecurityNotification(this.exchange, SecurityNotification.EventType.LOGGED_OUT, this.account, this.mechanismName, true, UndertowMessages.MESSAGES.userLoggedOut(this.account.getPrincipal().getName()), true));
        this.account = null;
        this.mechanismName = null;
    }

    protected static final class Node<T> {
        final T item;
        Node<T> next;

        private Node(T item) {
            this.item = item;
        }
    }
}

