/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.ssl;

import java.security.KeyManagementException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.ssl.SNIContextMatcher;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.ssl.SNISSLEngine;

class SNISSLContextSpi
extends SSLContextSpi {
    private final SNIContextMatcher matcher;

    SNISSLContextSpi(SNIContextMatcher matcher) {
        this.matcher = matcher;
    }

    @Override
    protected void engineInit(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) throws KeyManagementException {
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        return this.matcher.getDefaultContext().getSocketFactory();
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return this.matcher.getDefaultContext().getServerSocketFactory();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        return new SNISSLEngine(this.matcher);
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String s2, int i) {
        return new SNISSLEngine(this.matcher, s2, i);
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        return this.matcher.getDefaultContext().getServerSessionContext();
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        return this.matcher.getDefaultContext().getClientSessionContext();
    }
}

