/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2;

import java.nio.ByteBuffer;
import java.util.List;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.PooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.Http2Channel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.Http2ProtocolUtils;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.Http2Setting;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.Http2StreamSinkChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.framed.SendFrameHeader;

public class Http2SettingsStreamSinkChannel
extends Http2StreamSinkChannel {
    private final List<Http2Setting> settings;

    Http2SettingsStreamSinkChannel(Http2Channel channel, List<Http2Setting> settings) {
        super(channel, 0);
        this.settings = settings;
    }

    Http2SettingsStreamSinkChannel(Http2Channel channel) {
        super(channel, 0);
        this.settings = null;
    }

    @Override
    protected SendFrameHeader createFrameHeaderImpl() {
        PooledByteBuffer pooled = ((Http2Channel)this.getChannel()).getBufferPool().allocate();
        ByteBuffer currentBuffer = pooled.getBuffer();
        if (this.settings != null) {
            int size = this.settings.size() * 6;
            currentBuffer.put((byte)(size >> 16 & 0xFF));
            currentBuffer.put((byte)(size >> 8 & 0xFF));
            currentBuffer.put((byte)(size & 0xFF));
            currentBuffer.put((byte)4);
            currentBuffer.put((byte)0);
            Http2ProtocolUtils.putInt(currentBuffer, this.getStreamId());
            for (Http2Setting setting : this.settings) {
                currentBuffer.put((byte)(setting.getId() >> 8 & 0xFF));
                currentBuffer.put((byte)(setting.getId() & 0xFF));
                currentBuffer.put((byte)(setting.getValue() >> 24 & 0xFFL));
                currentBuffer.put((byte)(setting.getValue() >> 16 & 0xFFL));
                currentBuffer.put((byte)(setting.getValue() >> 8 & 0xFFL));
                currentBuffer.put((byte)(setting.getValue() & 0xFFL));
            }
        } else {
            currentBuffer.put((byte)0);
            currentBuffer.put((byte)0);
            currentBuffer.put((byte)0);
            currentBuffer.put((byte)4);
            currentBuffer.put((byte)1);
            Http2ProtocolUtils.putInt(currentBuffer, this.getStreamId());
        }
        currentBuffer.flip();
        return new SendFrameHeader(pooled);
    }
}

