/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicate;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.PredicateBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HttpString;

public class MethodPredicate
implements Predicate {
    private final HttpString[] methods;

    MethodPredicate(String[] methods) {
        HttpString[] values = new HttpString[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            values[i] = HttpString.tryFromString(methods[i]);
        }
        this.methods = values;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        for (int i = 0; i < this.methods.length; ++i) {
            if (!value.getRequestMethod().equals(this.methods[i])) continue;
            return true;
        }
        return false;
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "method";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("value", String[].class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("value");
        }

        @Override
        public String defaultParameter() {
            return "value";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            String[] methods = (String[])config.get("value");
            return new MethodPredicate(methods);
        }
    }
}

