/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.ByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.PooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.io.BufferWritableOutputStream;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Bits;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Buffers;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.Channels;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSinkChannel;

public class UndertowOutputStream
extends OutputStream
implements BufferWritableOutputStream {
    private final HttpServerExchange exchange;
    private ByteBuffer buffer;
    private PooledByteBuffer pooledBuffer;
    private StreamSinkChannel channel;
    private int state;
    private long written;
    private final long contentLength;
    private static final int FLAG_CLOSED = 1;
    private static final int FLAG_WRITE_STARTED = 2;
    private static final int MAX_BUFFERS_TO_ALLOCATE = 10;

    public UndertowOutputStream(HttpServerExchange exchange) {
        this.exchange = exchange;
        this.contentLength = exchange.getResponseContentLength();
    }

    public void resetBuffer() {
        if (Bits.anyAreSet(this.state, 2)) {
            throw UndertowMessages.MESSAGES.cannotResetBuffer();
        }
        this.buffer = null;
        IoUtils.safeClose((Closeable)this.pooledBuffer);
        this.pooledBuffer = null;
        this.written = 0L;
    }

    public long getBytesWritten() {
        return this.written;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 1) {
            return;
        }
        if (this.exchange.isInIoThread()) {
            throw UndertowMessages.MESSAGES.blockingIoFromIOThread();
        }
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        ByteBuffer buffer = this.buffer();
        if ((long)len == this.contentLength - this.written || buffer.remaining() < len) {
            if (buffer.remaining() < len) {
                StreamSinkChannel channel = this.channel;
                if (channel == null) {
                    this.channel = channel = this.exchange.getResponseChannel();
                }
                ByteBufferPool bufferPool = this.exchange.getConnection().getByteBufferPool();
                ByteBuffer[] buffers = new ByteBuffer[11];
                PooledByteBuffer[] pooledBuffers = new PooledByteBuffer[10];
                try {
                    int i;
                    buffers[0] = buffer;
                    int bytesWritten = 0;
                    int rem = buffer.remaining();
                    buffer.put(b, bytesWritten + off, rem);
                    buffer.flip();
                    bytesWritten += rem;
                    int bufferCount = 1;
                    for (i = 0; i < 10; ++i) {
                        PooledByteBuffer pooled;
                        pooledBuffers[bufferCount - 1] = pooled = bufferPool.allocate();
                        buffers[bufferCount++] = pooled.getBuffer();
                        int toWrite = len - bytesWritten;
                        ByteBuffer cb = pooled.getBuffer();
                        if (toWrite > cb.remaining()) {
                            rem = cb.remaining();
                            cb.put(b, bytesWritten + off, rem);
                            cb.flip();
                            bytesWritten += rem;
                            continue;
                        }
                        cb.put(b, bytesWritten + off, len - bytesWritten);
                        bytesWritten = len;
                        cb.flip();
                        break;
                    }
                    Channels.writeBlocking(channel, buffers, 0, bufferCount);
                    while (bytesWritten < len) {
                        bufferCount = 0;
                        for (i = 0; i < 11; ++i) {
                            ByteBuffer cb = buffers[i];
                            cb.clear();
                            ++bufferCount;
                            int toWrite = len - bytesWritten;
                            if (toWrite > cb.remaining()) {
                                rem = cb.remaining();
                                cb.put(b, bytesWritten + off, rem);
                                cb.flip();
                                bytesWritten += rem;
                                continue;
                            }
                            cb.put(b, bytesWritten + off, len - bytesWritten);
                            bytesWritten = len;
                            cb.flip();
                            break;
                        }
                        Channels.writeBlocking(channel, buffers, 0, bufferCount);
                    }
                    buffer.clear();
                }
                finally {
                    PooledByteBuffer p;
                    for (int i = 0; i < pooledBuffers.length && (p = pooledBuffers[i]) != null; ++i) {
                        p.close();
                    }
                }
            } else {
                buffer.put(b, off, len);
                if (buffer.remaining() == 0) {
                    this.writeBufferBlocking(false);
                }
            }
        } else {
            buffer.put(b, off, len);
            if (buffer.remaining() == 0) {
                this.writeBufferBlocking(false);
            }
        }
        this.updateWritten(len);
    }

    @Override
    public void write(ByteBuffer[] buffers) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        int len = 0;
        for (ByteBuffer buf : buffers) {
            len += buf.remaining();
        }
        if (len < 1) {
            return;
        }
        if (this.written == 0L && (long)len == this.contentLength) {
            if (this.channel == null) {
                this.channel = this.exchange.getResponseChannel();
            }
            Channels.writeBlocking(this.channel, buffers, 0, buffers.length);
            this.state |= 2;
        } else {
            ByteBuffer buffer = this.buffer();
            if (len < buffer.remaining()) {
                Buffers.copy(buffer, buffers, 0, buffers.length);
            } else {
                if (this.channel == null) {
                    this.channel = this.exchange.getResponseChannel();
                }
                if (buffer.position() == 0) {
                    Channels.writeBlocking(this.channel, buffers, 0, buffers.length);
                } else {
                    ByteBuffer[] newBuffers = new ByteBuffer[buffers.length + 1];
                    buffer.flip();
                    newBuffers[0] = buffer;
                    System.arraycopy(buffers, 0, newBuffers, 1, buffers.length);
                    Channels.writeBlocking(this.channel, newBuffers, 0, newBuffers.length);
                    buffer.clear();
                }
                this.state |= 2;
            }
        }
        this.updateWritten(len);
    }

    @Override
    public void write(ByteBuffer byteBuffer) throws IOException {
        this.write(new ByteBuffer[]{byteBuffer});
    }

    void updateWritten(long len) throws IOException {
        this.written += len;
        if (this.contentLength != -1L && this.written >= this.contentLength) {
            this.flush();
            this.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        if (this.buffer != null && this.buffer.position() != 0) {
            this.writeBufferBlocking(false);
        }
        if (this.channel == null) {
            this.channel = this.exchange.getResponseChannel();
        }
        Channels.flushBlocking(this.channel);
    }

    private void writeBufferBlocking(boolean writeFinal) throws IOException {
        if (this.channel == null) {
            this.channel = this.exchange.getResponseChannel();
        }
        this.buffer.flip();
        while (this.buffer.hasRemaining()) {
            if (writeFinal) {
                this.channel.writeFinal(this.buffer);
            } else {
                this.channel.write(this.buffer);
            }
            if (!this.buffer.hasRemaining()) continue;
            this.channel.awaitWritable();
        }
        this.buffer.clear();
        this.state |= 2;
    }

    @Override
    public void transferFrom(FileChannel source) throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        if (this.buffer != null && this.buffer.position() != 0) {
            this.writeBufferBlocking(false);
        }
        if (this.channel == null) {
            this.channel = this.exchange.getResponseChannel();
        }
        long position = source.position();
        long size = source.size();
        Channels.transferBlocking(this.channel, source, position, size);
        this.updateWritten(size - position);
    }

    @Override
    public void close() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            return;
        }
        try {
            this.state |= 1;
            if (Bits.anyAreClear(this.state, 2) && this.channel == null) {
                if (this.buffer == null) {
                    this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "0");
                } else {
                    this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "" + this.buffer.position());
                }
            }
            if (this.buffer != null) {
                this.writeBufferBlocking(true);
            }
            if (this.channel == null) {
                this.channel = this.exchange.getResponseChannel();
            }
            if (this.channel == null) {
                return;
            }
            StreamSinkChannel channel = this.channel;
            channel.shutdownWrites();
            Channels.flushBlocking(channel);
        }
        finally {
            if (this.pooledBuffer != null) {
                this.pooledBuffer.close();
                this.buffer = null;
            } else {
                this.buffer = null;
            }
        }
    }

    private ByteBuffer buffer() {
        ByteBuffer buffer = this.buffer;
        if (buffer != null) {
            return buffer;
        }
        this.pooledBuffer = this.exchange.getConnection().getByteBufferPool().allocate();
        this.buffer = this.pooledBuffer.getBuffer();
        return this.buffer;
    }
}

