/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.ByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.PooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Bits;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Buffers;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.Channels;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.EmptyStreamSourceChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSourceChannel;

public class UndertowInputStream
extends InputStream {
    private final StreamSourceChannel channel;
    private final ByteBufferPool bufferPool;
    private static final int FLAG_CLOSED = 1;
    private static final int FLAG_FINISHED = 2;
    private int state;
    private PooledByteBuffer pooled;

    public UndertowInputStream(HttpServerExchange exchange) {
        this.channel = exchange.isRequestChannelAvailable() ? exchange.getRequestChannel() : new EmptyStreamSourceChannel(exchange.getIoThread());
        this.bufferPool = exchange.getConnection().getByteBufferPool();
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b);
        if (read == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (Thread.currentThread() == this.channel.getIoThread()) {
            throw UndertowMessages.MESSAGES.blockingIoFromIOThread();
        }
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        this.readIntoBuffer();
        if (Bits.anyAreSet(this.state, 2)) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        ByteBuffer buffer = this.pooled.getBuffer();
        int copied = Buffers.copy(ByteBuffer.wrap(b, off, len), buffer);
        if (!buffer.hasRemaining()) {
            this.pooled.close();
            this.pooled = null;
        }
        return copied;
    }

    private void readIntoBuffer() throws IOException {
        if (this.pooled == null && !Bits.anyAreSet(this.state, 2)) {
            this.pooled = this.bufferPool.allocate();
            int res = Channels.readBlocking(this.channel, this.pooled.getBuffer());
            this.pooled.getBuffer().flip();
            if (res == -1) {
                this.state |= 2;
                this.pooled.close();
                this.pooled = null;
            }
        }
    }

    private void readIntoBufferNonBlocking() throws IOException {
        if (this.pooled == null && !Bits.anyAreSet(this.state, 2)) {
            this.pooled = this.bufferPool.allocate();
            int res = this.channel.read(this.pooled.getBuffer());
            if (res == 0) {
                this.pooled.close();
                this.pooled = null;
                return;
            }
            this.pooled.getBuffer().flip();
            if (res == -1) {
                this.state |= 2;
                this.pooled.close();
                this.pooled = null;
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
        this.readIntoBufferNonBlocking();
        if (Bits.anyAreSet(this.state, 2)) {
            return -1;
        }
        if (this.pooled == null) {
            return 0;
        }
        return this.pooled.getBuffer().remaining();
    }

    @Override
    public void close() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            return;
        }
        this.state |= 1;
        try {
            while (Bits.allAreClear(this.state, 2)) {
                this.readIntoBuffer();
                if (this.pooled == null) continue;
                this.pooled.close();
                this.pooled = null;
            }
        }
        finally {
            if (this.pooled != null) {
                this.pooled.close();
                this.pooled = null;
            }
            this.channel.shutdownReads();
            this.state |= 2;
        }
    }
}

