/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.ConduitListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.Connectors;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Bits;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSinkChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.AbstractStreamSourceConduit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.StreamSourceConduit;

public final class FixedLengthStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private final ConduitListener<? super FixedLengthStreamSourceConduit> finishListener;
    private long state;
    private static final long FLAG_CLOSED = Long.MIN_VALUE;
    private static final long FLAG_FINISHED = 0x4000000000000000L;
    private static final long FLAG_LENGTH_CHECKED = 0x2000000000000000L;
    private static final long MASK_COUNT = Bits.longBitMask(0, 60);
    private final HttpServerExchange exchange;

    public FixedLengthStreamSourceConduit(StreamSourceConduit next, long contentLength, ConduitListener<? super FixedLengthStreamSourceConduit> finishListener, HttpServerExchange exchange) {
        super(next);
        this.finishListener = finishListener;
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content length must be greater than or equal to zero");
        }
        if (contentLength > MASK_COUNT) {
            throw new IllegalArgumentException("Content length is too long");
        }
        this.state = contentLength;
        this.exchange = exchange;
    }

    public FixedLengthStreamSourceConduit(StreamSourceConduit next, long contentLength, ConduitListener<? super FixedLengthStreamSourceConduit> finishListener) {
        this(next, contentLength, finishListener, null);
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long val = this.state;
        this.checkMaxSize(val);
        if (Bits.anyAreSet(val, -4611686018427387904L) || Bits.allAreClear(val, MASK_COUNT)) {
            if (Bits.allAreClear(val, 0x4000000000000000L)) {
                this.invokeFinishListener();
            }
            return -1L;
        }
        long res = 0L;
        try {
            long l = res = ((StreamSourceConduit)this.next).transferTo(position, Math.min(count, val & MASK_COUNT), target);
            return l;
        }
        catch (IOException | Error | RuntimeException e) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e;
        }
        finally {
            this.exitRead(res);
        }
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        if (count == 0L) {
            return 0L;
        }
        long val = this.state;
        this.checkMaxSize(val);
        if (Bits.anyAreSet(val, -4611686018427387904L) || Bits.allAreClear(val, MASK_COUNT)) {
            if (Bits.allAreClear(val, 0x4000000000000000L)) {
                this.invokeFinishListener();
            }
            return -1L;
        }
        long res = 0L;
        try {
            long l = res = ((StreamSourceConduit)this.next).transferTo(Math.min(count, val & MASK_COUNT), throughBuffer, target);
            return l;
        }
        catch (IOException | Error | RuntimeException e) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e;
        }
        finally {
            this.exitRead(res + (long)throughBuffer.remaining());
        }
    }

    private void checkMaxSize(long state) throws IOException {
        if (Bits.anyAreClear(state, 0x2000000000000000L)) {
            HttpServerExchange exchange = this.exchange;
            if (exchange != null && exchange.getMaxEntitySize() > 0L && exchange.getMaxEntitySize() < (state & MASK_COUNT)) {
                Connectors.terminateRequest(exchange);
                exchange.setPersistent(false);
                this.finishListener.handleEvent(this);
                this.state |= 0xC000000000000000L;
                throw UndertowMessages.MESSAGES.requestEntityWasTooLarge(exchange.getMaxEntitySize());
            }
            this.state |= 0x2000000000000000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (length == 0) {
            return 0L;
        }
        if (length == 1) {
            return this.read(dsts[offset]);
        }
        long val = this.state;
        this.checkMaxSize(val);
        if (Bits.allAreSet(val, Long.MIN_VALUE) || Bits.allAreClear(val, MASK_COUNT)) {
            if (Bits.allAreClear(val, 0x4000000000000000L)) {
                this.invokeFinishListener();
            }
            return -1L;
        }
        long res = 0L;
        try {
            if ((val & MASK_COUNT) == 0L) {
                long l = -1L;
                return l;
            }
            long t = 0L;
            for (int i = 0; i < length; ++i) {
                ByteBuffer buffer = dsts[i + offset];
                int lim = buffer.limit();
                if ((t += (long)(lim - buffer.position())) <= (val & MASK_COUNT)) continue;
                buffer.limit(lim - (int)(t - (val & MASK_COUNT)));
                try {
                    long l = res = ((StreamSourceConduit)this.next).read(dsts, offset, i + 1);
                    return l;
                }
                finally {
                    buffer.limit(lim);
                }
            }
        }
        catch (IOException | Error | RuntimeException e) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e;
        }
        finally {
            this.exitRead(res);
        }
        long l = res = ((StreamSourceConduit)this.next).read(dsts, offset, length);
        return l;
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        long val = this.state;
        this.checkMaxSize(val);
        if (Bits.allAreSet(val, Long.MIN_VALUE) || Bits.allAreClear(val, MASK_COUNT)) {
            if (Bits.allAreClear(val, 0x4000000000000000L)) {
                this.invokeFinishListener();
            }
            return -1;
        }
        int res = 0;
        long remaining = val & MASK_COUNT;
        try {
            int lim = dst.limit();
            int pos = dst.position();
            if ((long)(lim - pos) > remaining) {
                dst.limit((int)(remaining + (long)pos));
                try {
                    int n = res = ((StreamSourceConduit)this.next).read(dst);
                    return n;
                }
                finally {
                    dst.limit(lim);
                }
            }
            int n = res = ((StreamSourceConduit)this.next).read(dst);
            return n;
        }
        catch (IOException | Error | RuntimeException e) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e;
        }
        finally {
            this.exitRead(res);
        }
    }

    @Override
    public boolean isReadResumed() {
        return Bits.allAreClear(this.state, Long.MIN_VALUE) && ((StreamSourceConduit)this.next).isReadResumed();
    }

    @Override
    public void wakeupReads() {
        long val = this.state;
        if (Bits.anyAreSet(val, -4611686018427387904L)) {
            return;
        }
        ((StreamSourceConduit)this.next).wakeupReads();
    }

    @Override
    public void terminateReads() throws IOException {
        long val = this.enterShutdownReads();
        if (Bits.allAreSet(val, Long.MIN_VALUE)) {
            return;
        }
        this.exitShutdownReads(val);
    }

    @Override
    public void awaitReadable() throws IOException {
        long val = this.state;
        if (Bits.allAreSet(val, Long.MIN_VALUE) || val == 0L) {
            return;
        }
        ((StreamSourceConduit)this.next).awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        long val = this.state;
        if (Bits.allAreSet(val, Long.MIN_VALUE) || val == 0L) {
            return;
        }
        try {
            ((StreamSourceConduit)this.next).awaitReadable(time, timeUnit);
        }
        catch (IOException | Error | RuntimeException e) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e;
        }
    }

    public long getRemaining() {
        return this.state & MASK_COUNT;
    }

    private long enterShutdownReads() {
        long newVal;
        long oldVal = this.state;
        if (Bits.anyAreSet(oldVal, Long.MIN_VALUE)) {
            return oldVal;
        }
        this.state = newVal = oldVal | Long.MIN_VALUE;
        return oldVal;
    }

    private void exitShutdownReads(long oldVal) {
        if (!Bits.allAreClear(oldVal, MASK_COUNT)) {
            this.invokeFinishListener();
        }
    }

    private void exitRead(long consumed) throws IOException {
        long newVal;
        long oldVal = this.state;
        if (consumed == -1L) {
            if (Bits.anyAreSet(oldVal, MASK_COUNT)) {
                this.invokeFinishListener();
                this.state &= MASK_COUNT ^ 0xFFFFFFFFFFFFFFFFL;
                throw UndertowMessages.MESSAGES.couldNotReadContentLengthData();
            }
            return;
        }
        this.state = newVal = oldVal - consumed;
    }

    private void invokeFinishListener() {
        this.state |= 0x4000000000000000L;
        this.finishListener.handleEvent(this);
    }
}

