/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute;

import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributeBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ReadOnlyAttributeException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;

public class RequestMethodAttribute
implements ExchangeAttribute {
    public static final String REQUEST_METHOD_SHORT = "%m";
    public static final String REQUEST_METHOD = "%{METHOD}";
    public static final ExchangeAttribute INSTANCE = new RequestMethodAttribute();

    private RequestMethodAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return exchange.getRequestMethod().toString();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Request method", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request method";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(RequestMethodAttribute.REQUEST_METHOD) || token.equals(RequestMethodAttribute.REQUEST_METHOD_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

