/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.com.sun.el.parser;

import java.lang.reflect.Method;
import net.thisptr.jmx.exporter.agent.shade.com.sun.el.lang.ELSupport;
import net.thisptr.jmx.exporter.agent.shade.com.sun.el.lang.EvaluationContext;
import net.thisptr.jmx.exporter.agent.shade.com.sun.el.parser.AstBracketSuffix;
import net.thisptr.jmx.exporter.agent.shade.com.sun.el.parser.AstDotSuffix;
import net.thisptr.jmx.exporter.agent.shade.com.sun.el.parser.AstIdentifier;
import net.thisptr.jmx.exporter.agent.shade.com.sun.el.parser.AstMethodArguments;
import net.thisptr.jmx.exporter.agent.shade.com.sun.el.parser.Node;
import net.thisptr.jmx.exporter.agent.shade.com.sun.el.parser.SimpleNode;
import net.thisptr.jmx.exporter.agent.shade.com.sun.el.util.MessageFactory;
import net.thisptr.jmx.exporter.agent.shade.com.sun.el.util.ReflectionUtil;
import net.thisptr.jmx.exporter.agent.shade.javax.el.ELClass;
import net.thisptr.jmx.exporter.agent.shade.javax.el.ELException;
import net.thisptr.jmx.exporter.agent.shade.javax.el.ELResolver;
import net.thisptr.jmx.exporter.agent.shade.javax.el.ImportHandler;
import net.thisptr.jmx.exporter.agent.shade.javax.el.MethodInfo;
import net.thisptr.jmx.exporter.agent.shade.javax.el.PropertyNotFoundException;
import net.thisptr.jmx.exporter.agent.shade.javax.el.PropertyNotWritableException;
import net.thisptr.jmx.exporter.agent.shade.javax.el.ValueReference;

public final class AstValue
extends SimpleNode {
    public AstValue(int id) {
        super(id);
    }

    @Override
    public Class getType(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        if (t.isMethodCall()) {
            return null;
        }
        Object property = t.suffixNode.getValue(ctx);
        ctx.setPropertyResolved(false);
        Class<?> ret = ctx.getELResolver().getType(ctx, t.base, property);
        if (!ctx.isPropertyResolved()) {
            ELSupport.throwUnhandled(t.base, property);
        }
        return ret;
    }

    @Override
    public ValueReference getValueReference(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        if (t.isMethodCall()) {
            return null;
        }
        Object property = t.suffixNode.getValue(ctx);
        return new ValueReference(t.base, property);
    }

    private static AstMethodArguments getArguments(Node n) {
        if (n instanceof AstDotSuffix && n.jjtGetNumChildren() > 0) {
            return (AstMethodArguments)n.jjtGetChild(0);
        }
        if (n instanceof AstBracketSuffix && n.jjtGetNumChildren() > 1) {
            return (AstMethodArguments)n.jjtGetChild(1);
        }
        return null;
    }

    private Object getValue(Object base, Node child, EvaluationContext ctx) throws ELException {
        Object value = null;
        ELResolver resolver = ctx.getELResolver();
        Object property = child.getValue(ctx);
        AstMethodArguments args = AstValue.getArguments(child);
        if (args != null) {
            if (!(property instanceof String)) {
                throw new ELException(MessageFactory.get("error.method.name", property));
            }
            Class<?>[] paramTypes = args.getParamTypes();
            Object[] params = args.getParameters(ctx);
            ctx.setPropertyResolved(false);
            value = resolver.invoke(ctx, base, property, paramTypes, params);
        } else if (property != null) {
            ctx.setPropertyResolved(false);
            value = resolver.getValue(ctx, base, property);
            if (!ctx.isPropertyResolved()) {
                ELSupport.throwUnhandled(base, property);
            }
        }
        return value;
    }

    private final Object getBase(EvaluationContext ctx) {
        try {
            return this.children[0].getValue(ctx);
        }
        catch (PropertyNotFoundException ex) {
            if (this.children[0] instanceof AstIdentifier) {
                Class<?> c;
                String name = ((AstIdentifier)this.children[0]).image;
                ImportHandler importHandler = ctx.getImportHandler();
                if (importHandler != null && (c = importHandler.resolveClass(name)) != null) {
                    return new ELClass(c);
                }
            }
            throw ex;
        }
    }

    private final Target getTarget(EvaluationContext ctx) throws ELException {
        Object base = this.getBase(ctx);
        if (base == null) {
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.base", this.children[0].getImage()));
        }
        Object property = null;
        int propCount = this.jjtGetNumChildren() - 1;
        if (propCount > 1) {
            for (int i = 1; base != null && i < propCount; ++i) {
                base = this.getValue(base, this.children[i], ctx);
            }
            if (base == null) {
                throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", property));
            }
        }
        return new Target(base, this.children[propCount]);
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        Object base = this.getBase(ctx);
        int propCount = this.jjtGetNumChildren();
        for (int i = 1; base != null && i < propCount; ++i) {
            base = this.getValue(base, this.children[i], ctx);
        }
        return base;
    }

    @Override
    public boolean isReadOnly(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        if (t.isMethodCall()) {
            return true;
        }
        Object property = t.suffixNode.getValue(ctx);
        ctx.setPropertyResolved(false);
        boolean ret = ctx.getELResolver().isReadOnly(ctx, t.base, property);
        if (!ctx.isPropertyResolved()) {
            ELSupport.throwUnhandled(t.base, property);
        }
        return ret;
    }

    @Override
    public void setValue(EvaluationContext ctx, Object value) throws ELException {
        Target t = this.getTarget(ctx);
        if (t.isMethodCall()) {
            throw new PropertyNotWritableException(MessageFactory.get("error.syntax.set"));
        }
        Object property = t.suffixNode.getValue(ctx);
        ELResolver elResolver = ctx.getELResolver();
        ctx.setPropertyResolved(false);
        Class<?> targetType = elResolver.getType(ctx, t.base, property);
        if (ctx.isPropertyResolved()) {
            ctx.setPropertyResolved(false);
            Object targetValue = elResolver.convertToType(ctx, value, targetType);
            if (ctx.isPropertyResolved()) {
                value = targetValue;
            } else if (value != null || targetType.isPrimitive()) {
                value = ELSupport.coerceToType(value, targetType);
            }
        }
        ctx.setPropertyResolved(false);
        elResolver.setValue(ctx, t.base, property, value);
        if (!ctx.isPropertyResolved()) {
            ELSupport.throwUnhandled(t.base, property);
        }
    }

    @Override
    public MethodInfo getMethodInfo(EvaluationContext ctx, Class[] paramTypes) throws ELException {
        Target t = this.getTarget(ctx);
        if (t.isMethodCall()) {
            return null;
        }
        Object property = t.suffixNode.getValue(ctx);
        Method m3 = ReflectionUtil.findMethod(t.base.getClass(), property.toString(), paramTypes, null);
        return new MethodInfo(m3.getName(), m3.getReturnType(), m3.getParameterTypes());
    }

    @Override
    public Object invoke(EvaluationContext ctx, Class[] paramTypes, Object[] paramValues) throws ELException {
        Target t = this.getTarget(ctx);
        if (t.isMethodCall()) {
            AstMethodArguments args = AstValue.getArguments(t.suffixNode);
            paramTypes = args.getParamTypes();
            Object[] params = args.getParameters(ctx);
            String method = (String)t.suffixNode.getValue(ctx);
            ctx.setPropertyResolved(false);
            ELResolver resolver = ctx.getELResolver();
            return resolver.invoke(ctx, t.base, method, paramTypes, params);
        }
        Object property = t.suffixNode.getValue(ctx);
        Method m3 = ReflectionUtil.findMethod(t.base.getClass(), property.toString(), paramTypes, paramValues);
        return ReflectionUtil.invokeMethod(ctx, m3, t.base, paramValues);
    }

    @Override
    public boolean isParametersProvided() {
        return AstValue.getArguments(this.children[this.jjtGetNumChildren() - 1]) != null;
    }

    protected static class Target {
        protected Object base;
        protected Node suffixNode;

        Target(Object base, Node suffixNode) {
            this.base = base;
            this.suffixNode = suffixNode;
        }

        boolean isMethodCall() {
            return AstValue.getArguments(this.suffixNode) != null;
        }
    }
}

