/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.scraper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.thisptr.jmx.exporter.agent.Sample;
import net.thisptr.jmx.exporter.agent.misc.AttributeNamePattern;
import net.thisptr.jmx.exporter.agent.misc.FastObjectName;
import net.thisptr.jmx.exporter.agent.misc.Pair;
import net.thisptr.jmx.exporter.agent.scraper.ScrapeOutput;
import net.thisptr.jmx.exporter.agent.scraper.ScrapeRule;
import net.thisptr.jmx.exporter.agent.shade.com.google.common.cache.CacheBuilder;
import net.thisptr.jmx.exporter.agent.shade.com.google.common.cache.CacheLoader;
import net.thisptr.jmx.exporter.agent.shade.com.google.common.cache.LoadingCache;
import net.thisptr.jmx.exporter.agent.utils.MoreCollections;

public class Scraper<ScrapeRuleType extends ScrapeRule> {
    private static final Logger LOG = Logger.getLogger(Scraper.class.getName());
    private final MBeanServer server;
    private final List<ScrapeRuleType> rules;
    private final ScrapeRuleType defaultRule;
    private final LoadingCache<ObjectName, CachedMBeanInfo> mbeanInfoCache = CacheBuilder.newBuilder().refreshAfterWrite(60L, TimeUnit.SECONDS).build(new CacheLoader<ObjectName, CachedMBeanInfo>(){

        @Override
        public CachedMBeanInfo load(ObjectName name) throws InstanceNotFoundException {
            return Scraper.this.prepare(name);
        }
    });
    private final LoadingCache<FastObjectName, Pair<Boolean, RuleMatch>> findRuleEarlyCache = CacheBuilder.newBuilder().expireAfterWrite(600L, TimeUnit.SECONDS).build(new CacheLoader<FastObjectName, Pair<Boolean, RuleMatch>>(){

        @Override
        public Pair<Boolean, RuleMatch> load(FastObjectName name) {
            return Scraper.this.findRuleEarlyNoCache(name);
        }
    });
    private final LoadingCache<AttributeRuleCacheKey, RuleMatch> findRuleCache = CacheBuilder.newBuilder().expireAfterWrite(600L, TimeUnit.SECONDS).build(new CacheLoader<AttributeRuleCacheKey, RuleMatch>(){

        @Override
        public RuleMatch load(AttributeRuleCacheKey key) throws Exception {
            return Scraper.this.findRuleNoCache(key);
        }
    });
    private final LoadingCache<ObjectName, Set<String>> bannedMBeanAttributes = CacheBuilder.newBuilder().expireAfterWrite(600L, TimeUnit.SECONDS).build(new CacheLoader<ObjectName, Set<String>>(){

        @Override
        public Set<String> load(ObjectName name) {
            return Collections.newSetFromMap(new ConcurrentHashMap());
        }
    });
    public final CachedMBeanInfo MBEAN_INFO_NEGATIVE_CACHE = new CachedMBeanInfo(null, null, null, null);

    public Scraper(MBeanServer server, List<ScrapeRuleType> rules, ScrapeRuleType defaultRule) {
        this.server = server;
        this.rules = rules;
        this.defaultRule = defaultRule;
    }

    private Pair<Boolean, RuleMatch> findRuleEarly(FastObjectName name) {
        return this.findRuleEarlyCache.getUnchecked(name);
    }

    private Pair<Boolean, RuleMatch> findRuleEarlyNoCache(FastObjectName name) {
        LinkedHashMap<String, String> captures = new LinkedHashMap<String, String>();
        for (ScrapeRule rule : this.rules) {
            if (rule.patterns() == null || rule.patterns().isEmpty()) {
                if (rule.condition() == null) {
                    return Pair.of(true, new RuleMatch(this, rule, Collections.emptyMap()));
                }
                return Pair.of(false, null);
            }
            boolean nameMatches = false;
            for (AttributeNamePattern pattern : rule.patterns()) {
                if (pattern.nameMatches(name.domain(), name.keyProperties(), captures)) {
                    nameMatches = true;
                    if (pattern.attribute == null && rule.condition() == null) {
                        return Pair.of(true, new RuleMatch(this, rule, Collections.unmodifiableMap(captures)));
                    }
                }
                captures.clear();
            }
            if (!nameMatches) continue;
            return Pair.of(false, null);
        }
        return Pair.of(true, new RuleMatch(this, this.defaultRule, Collections.emptyMap()));
    }

    private RuleMatch findRule(FastObjectName name, String attributeName, MBeanInfo beanInfo, MBeanAttributeInfo attributeInfo) {
        return this.findRuleCache.getUnchecked(new AttributeRuleCacheKey(name, attributeName, beanInfo, attributeInfo));
    }

    private RuleMatch findRuleNoCache(AttributeRuleCacheKey key) {
        HashMap<String, String> captures = new HashMap<String, String>();
        for (ScrapeRule rule : this.rules) {
            boolean patternMatches = false;
            if (rule.patterns() == null || rule.patterns().isEmpty()) {
                patternMatches = true;
            } else {
                for (AttributeNamePattern pattern : rule.patterns()) {
                    if (pattern.matches(key.name.domain(), key.name.keyProperties(), key.attributeName, captures)) {
                        patternMatches = true;
                        break;
                    }
                    captures.clear();
                }
            }
            if (!patternMatches || rule.condition() != null && !rule.condition().evaluate(key.beanInfo, key.attributeInfo)) continue;
            return new RuleMatch(this, rule, Collections.unmodifiableMap(captures));
        }
        return new RuleMatch(this, this.defaultRule, Collections.emptyMap());
    }

    public void scrape(ScrapeOutput<ScrapeRuleType> output) throws InterruptedException {
        this.scrape(output, 0L, TimeUnit.MILLISECONDS);
    }

    private CachedMBeanInfo prepare(ObjectName _name) throws InstanceNotFoundException {
        MBeanInfo info;
        FastObjectName name = new FastObjectName(_name);
        Pair<Boolean, RuleMatch> ruleByName = this.findRuleEarly(name);
        if (((Boolean)ruleByName._1).booleanValue() && ((RuleMatch)ruleByName._2).rule.skip()) {
            return this.MBEAN_INFO_NEGATIVE_CACHE;
        }
        try {
            info = this.server.getMBeanInfo(_name);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (Throwable th) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, String.format("MBeanServer#getMBeanInfo(%s) #=> %s. This indicates a bug in the MBean. The MBean will be banned for 1 minutes.", _name, th.getClass().getSimpleName()), th);
            }
            return this.MBEAN_INFO_NEGATIVE_CACHE;
        }
        if (info == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, String.format("MBeanServer#getMBeanInfo(%s) #=> null. This indicates a bug in the MBean. The MBean will be banned for 1 minutes.", _name));
            }
            return this.MBEAN_INFO_NEGATIVE_CACHE;
        }
        Set bannedAttributes = (Set)this.bannedMBeanAttributes.getIfPresent(_name);
        HashMap<String, AttributeRule> requests = new HashMap<String, AttributeRule>();
        ArrayList<String> attributes = new ArrayList<String>();
        for (MBeanAttributeInfo attribute : info.getAttributes()) {
            try {
                RuleMatch ruleMatch;
                if (!attribute.isReadable() || bannedAttributes != null && bannedAttributes.contains(attribute.getName())) continue;
                if (((Boolean)ruleByName._1).booleanValue()) {
                    ruleMatch = (RuleMatch)ruleByName._2;
                } else {
                    ruleMatch = this.findRule(name, attribute.getName(), info, attribute);
                    if (ruleMatch.rule.skip()) continue;
                }
                requests.put(attribute.getName(), new AttributeRule(attribute, ruleMatch));
                attributes.add(attribute.getName());
            }
            catch (Throwable th) {
                if (!LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, String.format("Got an unexpected exception while enumerating the MBean attribute \"%s:%s\". This is likely a bug in scriptable-jmx-exporter. Please report an issue on GitHub.", name, attribute.getName()), th);
            }
        }
        return new CachedMBeanInfo(name, info, requests, attributes.toArray(new String[0]));
    }

    public void scrape(ScrapeOutput<ScrapeRuleType> output, long duration, TimeUnit unit) throws InterruptedException {
        Set<ObjectName> names;
        try {
            names = this.server.queryNames(null, null);
        }
        catch (Throwable th) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.log(Level.SEVERE, String.format("MBeanServer#queryNames(null, null) #=> %s. This is bad. We can't do anything but to return an empty response.", th.getClass().getSimpleName()), th);
            }
            return;
        }
        if (names == null) {
            LOG.log(Level.SEVERE, "MBeanServer#queryNames(null, null) #=> null. This is bad. We can't do anything but to return an empty response.");
            return;
        }
        MoreCollections.forEachSlowlyOverDuration(names, duration, unit, _name -> {
            block4: {
                try {
                    this.scrape(output, (ObjectName)_name);
                }
                catch (InstanceNotFoundException e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, String.format("MBeanServer#getMBeanInfo(%s) #=> %s. This can happen when the MBean is unregistered after queryNames() and is just a temporary thing.", _name, e.getClass().getSimpleName()), e);
                    }
                }
                catch (Throwable th) {
                    if (!LOG.isLoggable(Level.WARNING)) break block4;
                    LOG.log(Level.WARNING, String.format("Got an unexpected exception while processing the MBean \"%s\". This is likely a bug in scriptable-jmx-exporter. Please report an issue on GitHub.", _name), th);
                }
            }
        });
    }

    private void fallbackAndHandleNonAttributeList(ScrapeOutput<ScrapeRuleType> output, CachedMBeanInfo info, AttributeList obtainedAttributes, long timestamp) {
        if (obtainedAttributes.size() != info.attributeNamesToGet.length) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, String.format("MBeanServer#getAttributes(%s, %s) returned an AttributeList containing non-Attribute elemenets and the number of elements does not match.", info.name.objectName(), Arrays.toString(info.attributeNamesToGet)));
            }
            return;
        }
        for (int i = 0; i < info.attributeNamesToGet.length; ++i) {
            AttributeRule request = info.requests.get(info.attributeNamesToGet[i]);
            if (request == null) {
                if (!LOG.isLoggable(Level.WARNING)) continue;
                LOG.log(Level.WARNING, String.format("This is not expected happen. The attribute \"{}\" could not be found in requests.", info.attributeNamesToGet[i]));
                continue;
            }
            Object value = obtainedAttributes.get(i);
            if (value instanceof Attribute) {
                value = ((Attribute)value).getValue();
            }
            Sample sample = new Sample(request.ruleMatch.rule, request.ruleMatch.captures, timestamp, info.name, info.info, request.attribute, value);
            this.safeEmit(output, sample);
        }
    }

    public void scrape(ScrapeOutput<ScrapeRuleType> output, ObjectName _name) throws InstanceNotFoundException {
        List<Attribute> obtainedAttributeList;
        AttributeList obtainedAttributes;
        CachedMBeanInfo info;
        try {
            info = this.mbeanInfoCache.get(_name);
        }
        catch (Throwable th) {
            if (th.getCause() instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)th.getCause();
            }
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, String.format("Got an unexpected exception while collecting MBean information of \"%s\". This may be a bug in scriptable-jmx-exporter. Please report an issue on GitHub.", _name), th);
            }
            return;
        }
        if (info == this.MBEAN_INFO_NEGATIVE_CACHE) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        try {
            obtainedAttributes = this.server.getAttributes(_name, info.attributeNamesToGet);
        }
        catch (Throwable th) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, String.format("MBeanServer#getAttributes(%s, %s) #=> %s. The MBean is banned for 1 minutes.", _name, Arrays.toString(info.attributeNamesToGet), th.getClass().getSimpleName()), th);
            }
            this.mbeanInfoCache.put(_name, this.MBEAN_INFO_NEGATIVE_CACHE);
            return;
        }
        if (obtainedAttributes == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, String.format("MBeanServer#getAttributes(%s, %s) #=> null. The MBean is banned for 1 minutes.", _name, Arrays.toString(info.attributeNamesToGet)));
            }
            this.mbeanInfoCache.put(_name, this.MBEAN_INFO_NEGATIVE_CACHE);
            return;
        }
        try {
            obtainedAttributeList = obtainedAttributes.asList();
        }
        catch (IllegalArgumentException e) {
            this.fallbackAndHandleNonAttributeList(output, info, obtainedAttributes, timestamp);
            return;
        }
        int successfulAttributes = 0;
        for (Attribute attribute : obtainedAttributeList) {
            AttributeRule request2 = info.requests.get(attribute.getName());
            if (request2 == null) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, String.format("MBeanServer#getAttributes(%s, %s) returned an attribute named \"%s\" which we didn't request. This indicates a bug in the MBean. Ignored.", _name, info.attributeNamesToGet, attribute.getName()));
                continue;
            }
            ++successfulAttributes;
            Sample sample = new Sample(request2.ruleMatch.rule, request2.ruleMatch.captures, timestamp, info.name, info.info, request2.attribute, attribute.getValue());
            this.safeEmit(output, sample);
        }
        if (successfulAttributes != info.attributeNamesToGet.length) {
            int i = 0;
            HashMap<String, AttributeRule> requests = new HashMap<String, AttributeRule>(info.requests);
            String[] successfulAttributeNames = new String[successfulAttributes];
            for (Attribute attribute : obtainedAttributeList) {
                AttributeRule request3 = (AttributeRule)requests.remove(attribute.getName());
                if (request3 == null) continue;
                successfulAttributeNames[i++] = attribute.getName();
            }
            requests.forEach((attributeName, request) -> {
                block5: {
                    try {
                        Object value = this.server.getAttribute(_name, (String)attributeName);
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, String.format("MBeanServer#getAttribute(%s, %s) #=> %s, while expecting an exception. This is weird. Anyway, the attribute will be banned for 1 minutes.", _name, attributeName, value));
                        }
                    }
                    catch (Throwable th) {
                        if (th.getCause() instanceof UnsupportedOperationException) {
                            this.banAttribute(_name, (String)attributeName);
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, String.format("MBeanServer#getAttribute(%s, %s) #=> %s. The attribute will be banned for 10 minutes.", _name, attributeName, th.getClass().getSimpleName()), th);
                            }
                        }
                        if (!LOG.isLoggable(Level.FINE)) break block5;
                        LOG.log(Level.FINE, String.format("MBeanServer#getAttribute(%s, %s) #=> %s. The attribute will be banned for 1 minutes.", _name, attributeName, th.getClass().getSimpleName()), th);
                    }
                }
            });
            this.mbeanInfoCache.put(_name, new CachedMBeanInfo(info.name, info.info, info.requests, successfulAttributeNames));
        }
    }

    private String safeFormatValue(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return value.toString();
        }
        catch (Throwable th) {
            return "<failed to format value>";
        }
    }

    private void safeEmit(ScrapeOutput<ScrapeRuleType> output, Sample<ScrapeRuleType> sample) {
        block2: {
            try {
                output.emit(sample);
            }
            catch (Throwable th) {
                if (!LOG.isLoggable(Level.WARNING)) break block2;
                LOG.log(Level.WARNING, String.format("The callback raised an exception, while processing an MBean attribute: name = %s, attribute = %s, type = %s, value = %s. This indicates a bug in the transform script.", sample.name, sample.attribute.getName(), sample.attribute.getType(), this.safeFormatValue(sample.value)), th);
            }
        }
    }

    private boolean banAttribute(ObjectName name, String attribute) {
        return this.bannedMBeanAttributes.getUnchecked(name).add(attribute);
    }

    private static class RuleMatch {
        public final ScrapeRuleType rule;
        public final Map<String, String> captures;
        final /* synthetic */ Scraper this$0;

        public RuleMatch(ScrapeRuleType rule, Map<String, String> captures) {
            this.this$0 = var1_1;
            this.rule = rule;
            this.captures = captures;
        }
    }

    private class CachedMBeanInfo {
        public final FastObjectName name;
        public final MBeanInfo info;
        public final Map<String, AttributeRule> requests;
        public final String[] attributeNamesToGet;

        public CachedMBeanInfo(FastObjectName name, MBeanInfo info, Map<String, AttributeRule> requests, String[] attributeNamesToRequest) {
            this.name = name;
            this.info = info;
            this.attributeNamesToGet = attributeNamesToRequest;
            this.requests = requests;
        }
    }

    private class AttributeRule {
        public final MBeanAttributeInfo attribute;
        public final RuleMatch ruleMatch;

        public AttributeRule(MBeanAttributeInfo attribute, RuleMatch ruleMatch) {
            this.attribute = attribute;
            this.ruleMatch = ruleMatch;
        }
    }

    private static class AttributeRuleCacheKey {
        public final FastObjectName name;
        public final String attributeName;
        public final MBeanInfo beanInfo;
        public final MBeanAttributeInfo attributeInfo;

        public AttributeRuleCacheKey(FastObjectName name, String attributeName, MBeanInfo beanInfo, MBeanAttributeInfo attributeInfo) {
            this.name = name;
            this.attributeName = attributeName;
            this.beanInfo = beanInfo;
            this.attributeInfo = attributeInfo;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.attributeName == null ? 0 : this.attributeName.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AttributeRuleCacheKey other = (AttributeRuleCacheKey)obj;
            if (this.attributeName == null ? other.attributeName != null : !this.attributeName.equals(other.attributeName)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

