/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.misc;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.ObjectName;
import net.thisptr.jmx.exporter.agent.javacc.AttributeNamePatternParser;
import net.thisptr.jmx.exporter.agent.misc.FastObjectName;
import net.thisptr.jmx.exporter.agent.misc.PatternAndCaptures;
import net.thisptr.jmx.exporter.agent.shade.com.google.common.annotations.VisibleForTesting;

public class AttributeNamePattern {
    public final PatternAndCaptures domain;
    public final Map<String, PatternAndCaptures> keys;
    public final PatternAndCaptures attribute;

    public AttributeNamePattern(String domain, Map<String, String> keys, String attribute) {
        this.domain = domain != null ? PatternAndCaptures.compile(domain) : null;
        LinkedHashMap tmp = new LinkedHashMap();
        keys.forEach((k, v) -> tmp.put(k, PatternAndCaptures.compile(v)));
        this.keys = Collections.unmodifiableMap(tmp);
        this.attribute = attribute != null ? PatternAndCaptures.compile(attribute) : null;
    }

    public boolean matches(String domainToTest, Map<String, String> keyPropertiesToTest, String attribute, Map<String, String> captures) {
        if (!this.nameMatches(domainToTest, keyPropertiesToTest, captures)) {
            return false;
        }
        return this.attribute == null || attribute != null && this.attribute.matches(attribute, captures);
    }

    @VisibleForTesting
    boolean matches(ObjectName name_, String attribute) {
        return this.matches(name_, attribute, null);
    }

    @VisibleForTesting
    boolean matches(ObjectName name_, String attribute, Map<String, String> captures) {
        FastObjectName name = new FastObjectName(name_);
        return this.matches(name.domain(), name.keyProperties(), attribute, captures);
    }

    public static AttributeNamePattern compile(String patternText) {
        return AttributeNamePatternParser.parse(patternText);
    }

    public boolean nameMatches(String domainToTest, Map<String, String> keyPropertiesToTest, Map<String, String> captures) {
        if (this.domain != null && !this.domain.matches(domainToTest, captures)) {
            return false;
        }
        for (Map.Entry<String, PatternAndCaptures> patternEntry : this.keys.entrySet()) {
            String targetValue = keyPropertiesToTest.get(patternEntry.getKey());
            if (targetValue == null) {
                return false;
            }
            if (patternEntry.getValue().matches(targetValue, captures)) continue;
            return false;
        }
        return true;
    }
}

