/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.handler.janino.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import net.thisptr.jmx.exporter.agent.handler.janino.api.MetricValue;
import net.thisptr.jmx.exporter.agent.handler.janino.api.MetricValueOutput;
import net.thisptr.jmx.exporter.agent.handler.janino.internal.Labels;
import net.thisptr.jmx.exporter.agent.handler.janino.internal.MetricNamer;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.jmx.exporter.agent.shade.com.google.common.collect.Maps;
import net.thisptr.jmx.exporter.agent.utils.MoreClasses;

public class ValueTransformations {
    private static final Logger LOG = Logger.getLogger(ValueTransformations.class.getName());
    private static final Set<NameAndLabels> SUPPRESSED_TYPES = Collections.newSetFromMap(new ConcurrentHashMap());

    private static void unfoldArray(MetricNamer namer, Labels labels, Object arrayValue, String arrayType, MetricValueOutput output) {
        String elementType = MoreClasses.elementTypeNameOf(arrayType);
        int length = Array.getLength(arrayValue);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(arrayValue, i);
            labels.push("index", String.valueOf(i));
            ValueTransformations.unfold(namer, labels, element, elementType, output);
            labels.pop("index");
        }
    }

    private static void unfoldListType(MetricNamer namer, Labels labels, List<Object> list, MetricValueOutput output) {
        int length = list.size();
        for (int i = 0; i < length; ++i) {
            Object element = list.get(i);
            labels.push("index", String.valueOf(i));
            ValueTransformations.unfoldByDynamicType(namer, labels, element, output);
            labels.pop("index");
        }
    }

    private static void unfoldCompositeData(MetricNamer namer, Labels labels, CompositeData compositeData, MetricValueOutput output) {
        CompositeType compositeType = compositeData.getCompositeType();
        for (String key : compositeType.keySet()) {
            int mark = namer.push(key);
            ValueTransformations.unfold(namer, labels, compositeData.get(key), compositeType.getType(key).getClassName(), output);
            namer.pop(mark);
        }
    }

    private static void unfoldTabularData(MetricNamer namer, Labels labels, TabularData tabularData, MetricValueOutput output) {
        TabularType tabularType = tabularData.getTabularType();
        CompositeType rowType = tabularType.getRowType();
        List<String> indexColumnNames = tabularType.getIndexNames();
        Set<String> columnNames = rowType.keySet();
        ArrayList<String> nonIndexColumnNames = new ArrayList<String>(Math.max(0, columnNames.size() - indexColumnNames.size()));
        for (String string : columnNames) {
            if (indexColumnNames.contains(string)) continue;
            nonIndexColumnNames.add(string);
        }
        ArrayList<String> nonIndexColumnTypes = new ArrayList<String>(nonIndexColumnNames.size());
        for (String string : nonIndexColumnNames) {
            nonIndexColumnTypes.add(rowType.getType(string).getClassName());
        }
        Collection<?> collection = tabularData.values();
        for (CompositeData row : collection) {
            int i;
            for (i = 0; i < indexColumnNames.size(); ++i) {
                String indexColumnName = indexColumnNames.get(i);
                labels.push(indexColumnName, String.valueOf(row.get(indexColumnName)));
            }
            for (i = 0; i < nonIndexColumnNames.size(); ++i) {
                String columnName = (String)nonIndexColumnNames.get(i);
                String columnType = (String)nonIndexColumnTypes.get(i);
                int mark = namer.push(columnName);
                ValueTransformations.unfold(namer, labels, row.get(columnName), columnType, output);
                namer.pop(mark);
            }
            for (i = indexColumnNames.size() - 1; i >= 0; --i) {
                labels.pop(indexColumnNames.get(i));
            }
        }
    }

    private static void unfoldMapType(MetricNamer namer, Labels labels, Map<Object, Object> map, MetricValueOutput output) {
        map.forEach((k, v) -> {
            labels.push("key", k.toString());
            ValueTransformations.unfoldByDynamicType(namer, labels, v, output);
            labels.pop("key");
        });
    }

    private static void unfoldByDynamicType(MetricNamer namer, Labels labels, Object value, MetricValueOutput output) {
        if (value == null) {
            return;
        }
        if (value instanceof Number) {
            ValueTransformations.emit(namer, labels, output, ((Number)value).doubleValue());
        } else if (value instanceof Boolean) {
            ValueTransformations.emit(namer, labels, output, (Boolean)value != false ? 1.0 : 0.0);
        } else if (value instanceof CompositeData) {
            ValueTransformations.unfoldCompositeData(namer, labels, (CompositeData)value, output);
        } else if (value instanceof TabularData) {
            ValueTransformations.unfoldTabularData(namer, labels, (TabularData)value, output);
        } else {
            NameAndLabels current = NameAndLabels.from(namer, labels);
            if (SUPPRESSED_TYPES.add(current)) {
                LOG.warning(String.format("Got unsupported dynamic type \"%s\" while processing %s. Further warnings are suppressed for the this metric.", value.getClass().getName(), current));
            }
        }
    }

    public static void unfold(MetricNamer namer, Labels labels, Object value, String type, MetricValueOutput output) {
        if (type == null) {
            if (value == null) {
                return;
            }
            ValueTransformations.unfoldByDynamicType(namer, labels, value, output);
            return;
        }
        switch (type) {
            case "double": 
            case "float": 
            case "int": 
            case "long": 
            case "short": 
            case "byte": 
            case "java.lang.Double": 
            case "java.lang.Float": 
            case "java.lang.Integer": 
            case "java.lang.Long": 
            case "java.lang.Short": 
            case "java.lang.Byte": {
                if (value == null) break;
                ValueTransformations.emit(namer, labels, output, ((Number)value).doubleValue());
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                if (value == null) break;
                ValueTransformations.emit(namer, labels, output, (Boolean)value != false ? 1.0 : 0.0);
                break;
            }
            case "javax.management.ObjectName": 
            case "java.lang.String": {
                break;
            }
            case "char": 
            case "java.lang.Character": {
                if (value == null) break;
                ValueTransformations.emit(namer, labels, output, ((Character)value).charValue());
                break;
            }
            case "javax.management.openmbean.CompositeData": {
                if (value == null) break;
                ValueTransformations.unfoldCompositeData(namer, labels, (CompositeData)value, output);
                break;
            }
            case "javax.management.openmbean.TabularData": {
                if (value == null) break;
                ValueTransformations.unfoldTabularData(namer, labels, (TabularData)value, output);
                break;
            }
            case "java.lang.Object": {
                if (value == null) break;
                ValueTransformations.unfoldByDynamicType(namer, labels, value, output);
                break;
            }
            case "java.util.Map": {
                if (value == null) break;
                Map mapValue = (Map)value;
                ValueTransformations.unfoldMapType(namer, labels, mapValue, output);
                break;
            }
            case "java.util.List": {
                if (value == null) break;
                List listValue = (List)value;
                ValueTransformations.unfoldListType(namer, labels, listValue, output);
                break;
            }
            default: {
                if (type.startsWith("[")) {
                    if (value == null) break;
                    ValueTransformations.unfoldArray(namer, labels, value, type, output);
                    break;
                }
                NameAndLabels current = NameAndLabels.from(namer, labels);
                if (!SUPPRESSED_TYPES.add(current)) break;
                LOG.warning(String.format("Got unsupported type \"%s\" while processing %s. Further warnings are suppressed for the this metric.", type, current));
                break;
            }
        }
    }

    private static void emit(MetricNamer namer, Labels labels, MetricValueOutput output, double value) {
        HashMap<String, String> metricLabels = Maps.newHashMapWithExpectedSize(labels.size());
        labels.forEach((label, labelValue) -> metricLabels.put((String)label, (String)labelValue));
        MetricValue m3 = new MetricValue();
        m3.name = namer.toString();
        m3.value = value;
        m3.labels = metricLabels;
        output.emit(m3);
    }

    private static class NameAndLabels {
        private final String name;
        private final Map<String, String> labels;

        public NameAndLabels(String name, Map<String, String> labels) {
            this.name = name;
            this.labels = labels;
        }

        public static NameAndLabels from(MetricNamer namer, Labels labels) {
            String currentName = namer.toString();
            HashMap<String, String> currentLabels = new HashMap<String, String>();
            labels.forEach(currentLabels::put);
            return new NameAndLabels(currentName, currentLabels);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.labels == null ? 0 : this.labels.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameAndLabels other = (NameAndLabels)obj;
            if (this.labels == null ? other.labels != null : !this.labels.equals(other.labels)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.name);
            builder.append('{');
            this.labels.forEach((k, v) -> {
                builder.append((String)k);
                builder.append('=');
                builder.append(TextNode.valueOf(v).toString());
                builder.append(',');
            });
            builder.append('}');
            return builder.toString();
        }
    }
}

