/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.handler.janino.internal;

import net.thisptr.jmx.exporter.agent.misc.StringWriter;

public class SnakeCaseWriter
implements StringWriter {
    private static final SnakeCaseWriter INSTANCE = new SnakeCaseWriter();

    public static SnakeCaseWriter getInstance() {
        return INSTANCE;
    }

    @Override
    public int expectedSize(String name) {
        return Math.max(1, name.length() * 2);
    }

    @Override
    public int write(String name, byte[] bytes, int index) {
        int savedIndex = index;
        int length = name.length();
        byte pcharType = CharactorGroup.INITIAL;
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                bytes[index++] = (byte)ch;
                pcharType = CharactorGroup.LOWER_CASE_ALPHABET;
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                char nchar;
                char c = nchar = i + 1 < length ? name.charAt(i + 1) : (char)'\u0000';
                if ('a' <= nchar && nchar <= 'z') {
                    if (CharactorGroup.subsequentLeadingCapitalNeedsUnderscore(pcharType)) {
                        bytes[index++] = 95;
                    }
                } else if (CharactorGroup.subsequentCapitalNeedsUnderscore(pcharType)) {
                    bytes[index++] = 95;
                }
                bytes[index++] = (byte)(ch + 32);
                pcharType = CharactorGroup.UPPER_CASE_ALPHABET;
                continue;
            }
            if (ch == ':' || ch == '_') {
                bytes[index++] = (byte)ch;
                pcharType = CharactorGroup.COLON_OR_UNDERSCORE;
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                if (savedIndex == index) {
                    bytes[index++] = 95;
                }
                bytes[index++] = (byte)ch;
                pcharType = CharactorGroup.NUMBER;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                ++i;
            }
            bytes[index++] = 95;
            pcharType = CharactorGroup.OTHER;
        }
        if (savedIndex == index) {
            bytes[index++] = 95;
        }
        return index;
    }

    private static class CharactorGroup {
        private static final byte LOWER_CASE_ALPHABET = CharactorGroup.encode(true, true);
        private static final byte UPPER_CASE_ALPHABET = CharactorGroup.encode(true, false);
        private static final byte NUMBER = CharactorGroup.encode(true, true);
        private static final byte COLON_OR_UNDERSCORE = CharactorGroup.encode(false, false);
        private static final byte OTHER = CharactorGroup.encode(false, false);
        private static final byte INITIAL = CharactorGroup.encode(false, false);

        private CharactorGroup() {
        }

        private static final byte encode(boolean subsequentLeadingCapitalNeedsUnderscore, boolean subsequentCapitalNeedsUnderscore) {
            byte val = 0;
            if (subsequentLeadingCapitalNeedsUnderscore) {
                val = (byte)(val | 2);
            }
            if (subsequentCapitalNeedsUnderscore) {
                val = (byte)(val | 1);
            }
            return val;
        }

        public static final boolean subsequentLeadingCapitalNeedsUnderscore(byte type) {
            return (type & 2) > 0;
        }

        public static final boolean subsequentCapitalNeedsUnderscore(byte type) {
            return (type & 1) > 0;
        }
    }
}

