/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.handler.janino.api.v1;

import java.util.Map;
import net.thisptr.jmx.exporter.agent.handler.janino.api.AttributeValue;
import net.thisptr.jmx.exporter.agent.handler.janino.api.MetricValue;
import net.thisptr.jmx.exporter.agent.handler.janino.api.MetricValueOutput;
import net.thisptr.jmx.exporter.agent.handler.janino.api._InternalUseDoNotImportProxyAccessor;
import net.thisptr.jmx.exporter.agent.handler.janino.internal.Labels;
import net.thisptr.jmx.exporter.agent.handler.janino.internal.LowerCaseWriter;
import net.thisptr.jmx.exporter.agent.handler.janino.internal.MetricNamer;
import net.thisptr.jmx.exporter.agent.handler.janino.internal.SnakeCaseWriter;
import net.thisptr.jmx.exporter.agent.handler.janino.internal.ValueTransformations;
import net.thisptr.jmx.exporter.agent.utils.MoreArrays;

public class V1 {
    private static final MetricValueModifier SNAKE_CASE = m3 -> _InternalUseDoNotImportProxyAccessor.setNameWriter(m3, SnakeCaseWriter.getInstance());
    private static final MetricValueModifier LOWER_CASE = m3 -> _InternalUseDoNotImportProxyAccessor.setNameWriter(m3, LowerCaseWriter.getInstance());
    private static final MetricValueModifier GAUGE = m3 -> {
        m3.type = "gauge";
    };
    private static final MetricValueModifier COUNTER = m3 -> {
        m3.type = "counter";
    };
    private static final MetricValueModifier HISTOGRAM = m3 -> {
        m3.type = "histogram";
    };
    private static final MetricValueModifier SUMMARY = m3 -> {
        m3.type = "summary";
    };
    private static final char DEFAULT_SEPARATOR = '_';
    private static final ThreadLocal<ThreadLocalCacheHolder> BUILDER_CACHE = new ThreadLocal<ThreadLocalCacheHolder>(){

        @Override
        protected ThreadLocalCacheHolder initialValue() {
            return new ThreadLocalCacheHolder();
        }
    };

    public static MetricValueModifier snakeCase() {
        return SNAKE_CASE;
    }

    public static MetricValueModifier lowerCase() {
        return LOWER_CASE;
    }

    public static MetricValueModifier gauge() {
        return GAUGE;
    }

    public static MetricValueModifier counter() {
        return COUNTER;
    }

    public static MetricValueModifier histogram() {
        return HISTOGRAM;
    }

    public static MetricValueModifier summary() {
        return SUMMARY;
    }

    public static MetricValueModifier suffix(String suffix) {
        return m3 -> {
            m3.suffix = suffix;
        };
    }

    public static void transform(AttributeValue in, MetricValueOutput out, MetricValueModifier ... modifiers) {
        V1.transformInternal(in, out, '_', modifiers, new String[0]);
    }

    public static void transform(AttributeValue in, MetricValueOutput out, String key1, MetricValueModifier ... modifiers) {
        V1.transformInternal(in, out, '_', modifiers, key1);
    }

    public static void transform(AttributeValue in, MetricValueOutput out, String key1, String key2, MetricValueModifier ... modifiers) {
        V1.transformInternal(in, out, '_', modifiers, key1, key2);
    }

    public static void transform(AttributeValue in, MetricValueOutput out, String key1, String key2, String key3, MetricValueModifier ... modifiers) {
        V1.transformInternal(in, out, '_', modifiers, key1, key2, key3);
    }

    public static void transform(AttributeValue in, MetricValueOutput out, String key1, String key2, String key3, String key4, MetricValueModifier ... modifiers) {
        V1.transformInternal(in, out, '_', modifiers, key1, key2, key3, key4);
    }

    public static void transform(AttributeValue in, MetricValueOutput out, String key1, String key2, String key3, String key4, String key5, MetricValueModifier ... modifiers) {
        V1.transformInternal(in, out, '_', modifiers, key1, key2, key3, key4, key5);
    }

    public static void transform(AttributeValue in, MetricValueOutput out, String[] keys, MetricValueModifier ... modifiers) {
        V1.transformInternal(in, out, '_', modifiers, keys);
    }

    public static void transform(AttributeValue in, MetricValueOutput out, char sep, MetricValueModifier ... modifiers) {
        V1.transformInternal(in, out, sep, modifiers, new String[0]);
    }

    public static void transform(AttributeValue in, MetricValueOutput out, char sep, String key1, MetricValueModifier ... modifiers) {
        V1.transformInternal(in, out, sep, modifiers, key1);
    }

    public static void transform(AttributeValue in, MetricValueOutput out, char sep, String key1, String key2, MetricValueModifier ... modifiers) {
        V1.transformInternal(in, out, sep, modifiers, key1, key2);
    }

    public static void transform(AttributeValue in, MetricValueOutput out, char sep, String key1, String key2, String key3, MetricValueModifier ... modifiers) {
        V1.transformInternal(in, out, sep, modifiers, key1, key2, key3);
    }

    public static void transform(AttributeValue in, MetricValueOutput out, char sep, String key1, String key2, String key3, String key4, MetricValueModifier ... modifiers) {
        V1.transformInternal(in, out, sep, modifiers, key1, key2, key3, key4);
    }

    public static void transform(AttributeValue in, MetricValueOutput out, char sep, String key1, String key2, String key3, String key4, String key5, MetricValueModifier ... modifiers) {
        V1.transformInternal(in, out, sep, modifiers, key1, key2, key3, key4, key5);
    }

    public static void transform(AttributeValue in, MetricValueOutput out, char sep, String[] keys, MetricValueModifier ... modifiers) {
        V1.transformInternal(in, out, sep, modifiers, keys);
    }

    private static void transformInternal(AttributeValue in, MetricValueOutput out, char sep, MetricValueModifier[] modifiers, String ... nameKeys) {
        Builder builder = V1.name(sep, in.domain);
        for (String nameKey : nameKeys) {
            String value = in.keyProperties.get(nameKey);
            if (value == null) continue;
            builder.appendName(value);
        }
        if (in.attributeName != null) {
            builder.appendName(in.attributeName);
        }
        builder.addLabelsExcluding(in.keyProperties, nameKeys);
        builder.timestamp(in.timestamp);
        builder.help(in.attributeDescription);
        builder.transform(in.value, in.attributeType, out, '_', modifiers);
        builder.dispose();
    }

    public static Builder name(char separator, String ... names) {
        Builder builder;
        ThreadLocalCacheHolder holder = BUILDER_CACHE.get();
        if (holder.builder != null) {
            builder = holder.builder;
            holder.builder = null;
        } else {
            builder = new Builder();
        }
        return builder.separator(separator).appendName(names);
    }

    public static Builder name(String ... names) {
        return V1.name('_', names);
    }

    private static final class ThreadLocalCacheHolder {
        public Builder builder;

        private ThreadLocalCacheHolder() {
        }
    }

    public static class Builder {
        private final MetricNamer namer = new MetricNamer(0);
        private final Labels labels = new Labels(0);
        private String suffix;
        private long timestamp;
        private String type;
        private String help;

        public Builder separator(char sep) {
            this.namer.separator(sep);
            return this;
        }

        public Builder appendName(String ... names) {
            for (String name : names) {
                if (name == null) continue;
                this.namer.push(name);
            }
            return this;
        }

        public Builder name(String ... names) {
            char savedSeparator = this.namer.separator();
            this.namer.clear();
            this.namer.separator(savedSeparator);
            this.appendName(names);
            return this;
        }

        public Builder addLabels(Map<String, String> labels) {
            labels.forEach((k, v) -> this.labels.push((String)k, (String)v));
            return this;
        }

        public Builder addLabelsExcluding(Map<String, String> labels, String ... names) {
            labels.forEach((k, v) -> {
                if (MoreArrays.contains(names, k)) {
                    return;
                }
                this.labels.push((String)k, (String)v);
            });
            return this;
        }

        public Builder addLabel(String name, String value) {
            this.labels.push(name, value);
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder help(String help) {
            this.help = help;
            return this;
        }

        public void reset() {
            this.namer.reset();
            this.labels.clear();
            this.suffix = null;
            this.timestamp = 0L;
            this.type = null;
            this.help = null;
        }

        public Builder transform(Object value, String type, MetricValueOutput out, MetricValueModifier ... modifiers) {
            return this.transform(value, type, out, '.', modifiers);
        }

        private Builder transform(Object value, String type, MetricValueOutput out, char separator, MetricValueModifier ... modifiers) {
            this.namer.separator(separator);
            ValueTransformations.unfold(this.namer, this.labels, value, type, m3 -> {
                m3.timestamp = this.timestamp;
                m3.help = this.help;
                m3.type = this.type;
                m3.suffix = this.suffix;
                for (MetricValueModifier modifier : modifiers) {
                    modifier.apply(m3);
                }
                out.emit(m3);
            });
            return this;
        }

        public void dispose() {
            this.reset();
            ((ThreadLocalCacheHolder)BUILDER_CACHE.get()).builder = this;
        }
    }

    public static interface MetricValueModifier {
        public void apply(MetricValue var1);
    }
}

