/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thisptr.jmx.exporter.agent.config.Config;
import net.thisptr.jmx.exporter.agent.config.ConfigWatcher;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.core.JsonParseException;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.databind.JsonMappingException;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import net.thisptr.jmx.exporter.agent.utils.MoreValidators;

public abstract class PollingConfigWatcher
extends Thread
implements ConfigWatcher {
    private static final Logger LOG = Logger.getLogger(PollingConfigWatcher.class.getName());
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper(new YAMLFactory());
    private final ConfigWatcher.ConfigListener listener;
    private volatile Config config;
    private volatile byte[] bytes;

    protected abstract String doGetPath();

    protected abstract byte[] doLoadConfig() throws IOException;

    public PollingConfigWatcher(ConfigWatcher.ConfigListener listener) throws JsonParseException, JsonMappingException, IOException {
        this.listener = listener;
        this.setName("Scriptable JMX Exporter " + PollingConfigWatcher.class.getSimpleName());
        this.setDaemon(true);
    }

    protected void runOnce() throws IOException {
        this.bytes = this.doLoadConfig();
        this.config = YAML_MAPPER.readValue(this.bytes, Config.class);
        MoreValidators.validate(this.config);
    }

    @Override
    public void run() {
        while (true) {
            Config newConfig;
            byte[] newBytes;
            block10: {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    LOG.log(Level.INFO, "Interrupted. Stopping Scriptable JMX Exporter " + PollingConfigWatcher.class.getSimpleName() + "...");
                    break;
                }
                try {
                    newBytes = this.doLoadConfig();
                    if (Arrays.equals(this.bytes, newBytes)) {
                    }
                    break block10;
                }
                catch (Throwable th) {
                    LOG.log(Level.WARNING, "Got exception while reloading " + this.doGetPath() + ".", th);
                }
                continue;
            }
            try {
                newConfig = YAML_MAPPER.readValue(newBytes, Config.class);
                MoreValidators.validate(newConfig);
            }
            catch (Throwable th) {
                LOG.log(Level.WARNING, "Got exception while reloading " + this.doGetPath() + ".", th);
                continue;
            }
            try {
                this.listener.changed(this.config, newConfig);
            }
            catch (Throwable th) {
                LOG.log(Level.WARNING, "Got exception while reconfiguring from " + this.doGetPath() + ".", th);
            }
            this.config = newConfig;
            this.bytes = newBytes;
        }
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public void shutdown() {
        this.interrupt();
    }
}

