/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.config;

import java.util.ArrayList;
import java.util.List;
import net.thisptr.jmx.exporter.agent.handler.ConditionScript;
import net.thisptr.jmx.exporter.agent.handler.Declarations;
import net.thisptr.jmx.exporter.agent.handler.ScriptEngine;
import net.thisptr.jmx.exporter.agent.handler.ScriptEngineRegistry;
import net.thisptr.jmx.exporter.agent.handler.TransformScript;
import net.thisptr.jmx.exporter.agent.jackson.serdes.AttributeNamePatternDeserializer;
import net.thisptr.jmx.exporter.agent.jackson.serdes.HostAndPortDeserializer;
import net.thisptr.jmx.exporter.agent.jackson.serdes.ScriptTextDeserializer;
import net.thisptr.jmx.exporter.agent.misc.AttributeNamePattern;
import net.thisptr.jmx.exporter.agent.misc.ScriptText;
import net.thisptr.jmx.exporter.agent.scraper.ScrapeRule;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.annotation.JsonFormat;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.annotation.JsonProperty;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import net.thisptr.jmx.exporter.agent.shade.com.google.common.net.HostAndPort;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.Valid;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.constraints.Max;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.constraints.Min;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.constraints.NotNull;

@JsonDeserialize(builder=Builder.class)
public class Config {
    @Valid
    @NotNull
    @JsonProperty(value="server")
    public ServerConfig server = new ServerConfig();
    @Valid
    @NotNull
    @JsonProperty(value="options")
    public OptionsConfig options = new OptionsConfig();
    @NotNull
    @JsonProperty(value="declarations")
    public List<Declarations> declarations = new ArrayList<Declarations>();
    @NotNull
    @JsonProperty(value="rules")
    public @NotNull List<@Valid @NotNull PrometheusScrapeRule> rules = new ArrayList<PrometheusScrapeRule>();

    public static class PrometheusScrapeRule
    implements ScrapeRule {
        @JsonProperty(value="pattern")
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        @JsonDeserialize(contentUsing=AttributeNamePatternDeserializer.class)
        public List<AttributeNamePattern> patterns;
        @JsonProperty(value="condition")
        public ConditionScript condition;
        @JsonProperty(value="skip")
        public boolean skip = false;
        @JsonProperty(value="transform")
        public TransformScript transform;

        @Override
        public boolean skip() {
            return this.skip;
        }

        @Override
        public List<AttributeNamePattern> patterns() {
            return this.patterns;
        }

        @Override
        public ConditionScript condition() {
            return this.condition;
        }
    }

    public static class OptionsConfig {
        @JsonProperty(value="include_timestamp")
        public boolean includeTimestamp = true;
        @JsonProperty(value="include_help")
        public boolean includeHelp = true;
        @JsonProperty(value="include_type")
        public boolean includeType = true;
        @Min(value=0L)
        @Max(value=60000L)
        @JsonProperty(value="minimum_response_time")
        public @Min(value=0L) @Max(value=60000L) long minimumResponseTime = 0L;
    }

    public static class ServerConfig {
        @NotNull
        @JsonProperty(value="bind_address")
        @JsonDeserialize(using=HostAndPortDeserializer.class)
        public HostAndPort bindAddress = HostAndPort.fromString("0.0.0.0:9639");
    }

    @JsonPOJOBuilder
    public static class Builder {
        private List<ScriptText> declarations = new ArrayList<ScriptText>();
        private List<RuleSource> ruleSources = new ArrayList<RuleSource>();
        private OptionsConfig options = new OptionsConfig();
        private ServerConfig server = new ServerConfig();
        private static final String DEFAULT_ENGINE_NAME = "java";

        @JsonProperty(value="declarations")
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        @JsonDeserialize(contentUsing=ScriptTextDeserializer.class)
        public Builder withDeclarations(List<ScriptText> declarations) {
            this.declarations = declarations;
            return this;
        }

        @NotNull
        @JsonProperty(value="rules")
        public Builder withRules(List<@Valid @NotNull RuleSource> rules) {
            this.ruleSources = rules;
            return this;
        }

        @JsonProperty(value="options")
        public Builder withOptions(OptionsConfig options) {
            this.options = options;
            return this;
        }

        @JsonProperty(value="server")
        public Builder withServer(ServerConfig server) {
            this.server = server;
            return this;
        }

        public Config build() throws Exception {
            ScriptEngineRegistry registry = ScriptEngineRegistry.getInstance();
            ArrayList<Declarations> declarations = new ArrayList<Declarations>();
            for (int i = 0; i < this.declarations.size(); ++i) {
                ScriptText script = this.declarations.get(i);
                ScriptEngine scriptEngine = registry.get(script.engineName != null ? script.engineName : DEFAULT_ENGINE_NAME);
                declarations.add(scriptEngine.compileDeclarations(script.scriptBody, i));
            }
            ArrayList<PrometheusScrapeRule> rules = new ArrayList<PrometheusScrapeRule>();
            for (RuleSource ruleSource : this.ruleSources) {
                ScriptEngine scriptEngine;
                PrometheusScrapeRule rule = new PrometheusScrapeRule();
                if (ruleSource.condition != null) {
                    scriptEngine = registry.get(ruleSource.condition.engineName != null ? ruleSource.condition.engineName : DEFAULT_ENGINE_NAME);
                    rule.condition = scriptEngine.compileConditionScript(declarations, ruleSource.condition.scriptBody);
                }
                if (ruleSource.transform != null) {
                    scriptEngine = registry.get(ruleSource.transform.engineName != null ? ruleSource.transform.engineName : DEFAULT_ENGINE_NAME);
                    rule.transform = scriptEngine.compileTransformScript(declarations, ruleSource.transform.scriptBody);
                }
                rule.skip = ruleSource.skip;
                rule.patterns = ruleSource.patterns;
                rules.add(rule);
            }
            Config config = new Config();
            config.server = this.server;
            config.options = this.options;
            config.declarations = declarations;
            config.rules = rules;
            return config;
        }

        public static class RuleSource {
            @JsonProperty(value="pattern")
            @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
            @JsonDeserialize(contentUsing=AttributeNamePatternDeserializer.class)
            public List<AttributeNamePattern> patterns;
            @JsonProperty(value="condition")
            @JsonDeserialize(using=ScriptTextDeserializer.class)
            public ScriptText condition;
            @JsonProperty(value="skip")
            public boolean skip = false;
            @JsonProperty(value="transform")
            @JsonDeserialize(using=ScriptTextDeserializer.class)
            public ScriptText transform;
        }
    }
}

