/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.config;

import java.io.IOException;
import java.io.InputStream;
import net.thisptr.jmx.exporter.agent.config.ConfigWatcher;
import net.thisptr.jmx.exporter.agent.config.PollingConfigWatcher;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.core.JsonParseException;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.databind.JsonMappingException;
import net.thisptr.jmx.exporter.agent.shade.com.google.common.io.ByteStreams;

public class ClassPathPollingConfigWatcher
extends PollingConfigWatcher {
    private final String path;

    public ClassPathPollingConfigWatcher(String path, ConfigWatcher.ConfigListener listener) throws JsonParseException, JsonMappingException, IOException {
        super(listener);
        this.path = path;
        this.runOnce();
    }

    @Override
    protected byte[] doLoadConfig() throws IOException {
        try (InputStream is = ClassPathPollingConfigWatcher.class.getClassLoader().getResourceAsStream(this.path);){
            byte[] byArray = ByteStreams.toByteArray(is);
            return byArray;
        }
    }

    @Override
    protected String doGetPath() {
        return "classpath:" + this.path;
    }
}

