/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thisptr.jmx.exporter.agent.PrometheusExporterHttpHandler;
import net.thisptr.jmx.exporter.agent.config.ClassPathPollingConfigWatcher;
import net.thisptr.jmx.exporter.agent.config.Config;
import net.thisptr.jmx.exporter.agent.config.ConfigWatcher;
import net.thisptr.jmx.exporter.agent.config.FilePollingConfigWatcher;
import net.thisptr.jmx.exporter.agent.config.StaticConfigWatcher;
import net.thisptr.jmx.exporter.agent.handler.ScriptEngineRegistry;
import net.thisptr.jmx.exporter.agent.handler.janino.JaninoScriptEngine;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.core.JsonParseException;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.databind.JsonMappingException;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.jmx.exporter.agent.shade.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import net.thisptr.jmx.exporter.agent.shade.com.google.common.net.HostAndPort;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.Undertow;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.encoding.ContentEncodingRepository;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.encoding.EncodingHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.encoding.GzipEncodingProvider;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Options;
import net.thisptr.jmx.exporter.agent.utils.MoreValidators;

public class Agent {
    private static final Logger LOG = Logger.getLogger(Agent.class.getName());
    private static final ObjectMapper MAPPER = new ObjectMapper(new YAMLFactory());
    static final String DEFAULT_CLASSPATH_CONFIG_FILE = "scriptable-jmx-exporter.yaml";
    private static Undertow SERVER;
    private static volatile PrometheusExporterHttpHandler HANDLER;

    private static ConfigWatcher newConfigWatcher(String args, ConfigWatcher.ConfigListener listener) throws JsonParseException, JsonMappingException, IOException {
        if (args == null) {
            args = "@classpath:scriptable-jmx-exporter.yaml";
        }
        if (args.isEmpty()) {
            return new StaticConfigWatcher(new Config());
        }
        if (args.startsWith("@classpath:")) {
            return new ClassPathPollingConfigWatcher(args.substring("@classpath:".length()), listener);
        }
        if (args.startsWith("@")) {
            return new FilePollingConfigWatcher(new File(args.substring(1)), listener);
        }
        Config config = MAPPER.readValue(args, Config.class);
        MoreValidators.validate(config);
        return new StaticConfigWatcher(config);
    }

    private static void safeStart(Undertow server) throws Throwable {
        try {
            server.start();
        }
        catch (Throwable th) {
            try {
                server.stop();
            }
            catch (Throwable th2) {
                th.addSuppressed(th2);
            }
            throw th;
        }
    }

    private static Undertow newServer(HostAndPort hostAndPort) {
        HttpHandler thisHandler = exchange -> HANDLER.handleRequest(exchange);
        EncodingHandler encodingHandler = new EncodingHandler(new ContentEncodingRepository().addEncodingHandler("gzip", new GzipEncodingProvider(), 50)).setNext(thisHandler);
        return Undertow.builder().setWorkerOption(Options.WORKER_NAME, "scriptable-jmx-exporter").addHttpListener(hostAndPort.getPort(), hostAndPort.getHost()).setHandler(encodingHandler).build();
    }

    public static void premain(String args) throws Throwable {
        LOG.log(Level.INFO, "Starting Scriptable JMX Exporter...");
        try {
            ConfigWatcher watcher = Agent.newConfigWatcher(args, (oldConfig, newConfig) -> {
                LOG.log(Level.FINE, "Detected configuration change. Reconfiguring Scriptable JMX Exporter...");
                PrometheusExporterHttpHandler handler = new PrometheusExporterHttpHandler(newConfig.rules, newConfig.options);
                if (!oldConfig.server.bindAddress.equals(newConfig.server.bindAddress)) {
                    try {
                        SERVER.stop();
                    }
                    catch (Throwable th) {
                        LOG.log(Level.WARNING, "Failed to stop Scriptable JMX Exporter server for reconfiguration.", th);
                    }
                    SERVER = Agent.newServer(newConfig.server.bindAddress);
                    Agent.safeStart(SERVER);
                }
                HANDLER = handler;
                LOG.log(Level.INFO, "Successfully reconfigured Scriptable JMX Exporter.");
            });
            Config initialConfig = watcher.config();
            HANDLER = new PrometheusExporterHttpHandler(initialConfig.rules, initialConfig.options);
            SERVER = Agent.newServer(initialConfig.server.bindAddress);
            Agent.safeStart(SERVER);
            watcher.start();
        }
        catch (Throwable th) {
            LOG.log(Level.SEVERE, "Failed to start Scriptable JMX Exporter.", th);
            System.exit(1);
        }
    }

    static {
        ScriptEngineRegistry registry = ScriptEngineRegistry.getInstance();
        registry.add("java", new JaninoScriptEngine());
    }
}

