/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.misc.jq;

import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import net.thisptr.java.prometheus.metrics.agent.jackson.JmxModule;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.MapperFeature;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.NullNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Expression;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.PathOutput;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Version;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.Path;

public class JmxFunction
implements Function {
    public static final ObjectMapper JMX_MAPPER = new ObjectMapper().registerModule(new JmxModule()).disable(MapperFeature.AUTO_DETECT_GETTERS).disable(MapperFeature.AUTO_DETECT_FIELDS).disable(MapperFeature.AUTO_DETECT_IS_GETTERS).disable(MapperFeature.AUTO_DETECT_SETTERS).disable(MapperFeature.AUTO_DETECT_CREATORS);

    private static JsonNode get(MBeanServer server, String name, String attribute) throws InstanceNotFoundException, ReflectionException, MBeanException, MalformedObjectNameException, AttributeNotFoundException {
        AttributeNotFoundException th = null;
        for (ObjectName on : server.queryNames(new ObjectName(name), null)) {
            try {
                Object value = server.getAttribute(on, attribute);
                return JMX_MAPPER.valueToTree(value);
            }
            catch (AttributeNotFoundException e) {
                th = e;
            }
        }
        if (th != null) {
            throw th;
        }
        throw new InstanceNotFoundException(name);
    }

    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path path, PathOutput output, Version version) throws JsonQueryException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Expression nameExpr = args.get(0);
        Expression attributeExpr = args.get(1);
        nameExpr.apply(scope, NullNode.getInstance(), name -> {
            if (!name.isTextual()) {
                throw new JsonQueryException("objectname must be string");
            }
            attributeExpr.apply(scope, NullNode.getInstance(), attribute -> {
                if (!attribute.isTextual()) {
                    throw new JsonQueryException("attribute must be string");
                }
                try {
                    output.emit(JmxFunction.get(server, name.asText(), attribute.asText()), null);
                }
                catch (Exception e) {
                    throw new JsonQueryException(e);
                }
            });
        });
    }
}

