/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.misc.jq;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.thisptr.java.prometheus.metrics.agent.JsonSample;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.core.JsonProcessingException;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.DoubleNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.google.common.collect.Maps;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Expression;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Function;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.PathOutput;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Version;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.Path;

public class DefaultTransformV1Function
implements Function {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path path, PathOutput output, Version version) throws JsonQueryException {
        if (args.size() == 2) {
            Expression nameKeysExpr = args.get(0);
            Expression attrAsNameExpr = args.get(1);
            nameKeysExpr.apply(scope, in, path, (nameKeysJson, nameKeysPath) -> {
                ArrayList<String> nameKeys = new ArrayList<String>(nameKeysJson.size());
                for (JsonNode nameKeyJson : nameKeysJson) {
                    nameKeys.add(nameKeyJson.asText());
                }
                attrAsNameExpr.apply(scope, in, path, (attrAsNameJson, attrAsNamePath) -> {
                    boolean attrAsName = attrAsNameJson.asBoolean();
                    DefaultTransformV1Function.transform(nameKeys, attrAsName, in, output);
                }, false);
            }, false);
        } else {
            DefaultTransformV1Function.transform(Collections.emptyList(), false, in, output);
        }
    }

    private static void unfold(List<String> nameKeys, boolean attrAsName, JsonSample sample, PathOutput output) {
        ArrayList<IndexLabel> labels = new ArrayList<IndexLabel>();
        ArrayList<String> names = new ArrayList<String>();
        DefaultTransformV1Function.unfold(nameKeys, attrAsName, labels, names, sample.value, sample, output);
    }

    private static String format(List<String> names) {
        StringBuilder builder = new StringBuilder();
        String sep = "";
        for (String name : names) {
            builder.append(sep);
            if (name == null) {
                builder.append("index");
            } else {
                builder.append(name);
            }
            sep = "_";
        }
        return builder.toString();
    }

    private static void unfold(List<String> nameKeys, boolean attrAsName, List<IndexLabel> labels, List<String> names, JsonNode value, JsonSample sample, PathOutput output) {
        block20: {
            block0 : switch (value.getNodeType()) {
                case ARRAY: {
                    Iterator<JsonNode> iter = value.iterator();
                    int index = 1;
                    while (iter.hasNext()) {
                        JsonNode item = iter.next();
                        names.add(null);
                        labels.add(new IndexLabel(DefaultTransformV1Function.format(names), String.valueOf(index)));
                        DefaultTransformV1Function.unfold(nameKeys, attrAsName, labels, names, item, sample, output);
                        labels.remove(labels.size() - 1);
                        names.remove(names.size() - 1);
                        ++index;
                    }
                    break;
                }
                case OBJECT: {
                    JsonNode type = value.get("$type");
                    if (type == null) break;
                    switch (type.asText()) {
                        case "javax.management.openmbean.CompositeData": {
                            Iterator<Map.Entry<String, JsonNode>> iter = value.fields();
                            while (iter.hasNext()) {
                                Map.Entry<String, JsonNode> entry = iter.next();
                                if ("$type".equals(entry.getKey())) continue;
                                names.add(entry.getKey());
                                DefaultTransformV1Function.unfold(nameKeys, attrAsName, labels, names, entry.getValue(), sample, output);
                                names.remove(names.size() - 1);
                            }
                            break block20;
                        }
                        case "javax.management.openmbean.TabularData": {
                            ArrayList indexNames = new ArrayList();
                            value.get("tabular_type").get("index_names").forEach(indexName -> indexNames.add(indexName.asText()));
                            for (JsonNode tabularRecord : value.get("values")) {
                                for (String indexName2 : indexNames) {
                                    names.add(indexName2);
                                    JsonNode labelValue = tabularRecord.get(indexName2);
                                    labels.add(new IndexLabel(DefaultTransformV1Function.format(names), labelValue.isTextual() ? labelValue.asText() : labelValue.toString()));
                                    names.remove(names.size() - 1);
                                }
                                Iterator<Map.Entry<String, JsonNode>> tabularFieldIterator = tabularRecord.fields();
                                while (tabularFieldIterator.hasNext()) {
                                    Map.Entry<String, JsonNode> tabularField = tabularFieldIterator.next();
                                    if (indexNames.contains(tabularField.getKey())) continue;
                                    names.add(tabularField.getKey());
                                    DefaultTransformV1Function.unfold(nameKeys, attrAsName, labels, names, tabularField.getValue(), sample, output);
                                    names.remove(names.size() - 1);
                                }
                                for (int i = 0; i < indexNames.size(); ++i) {
                                    labels.remove(labels.size() - 1);
                                }
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case NUMBER: {
                    DefaultTransformV1Function.emit(nameKeys, attrAsName, labels, names, sample, output, value.asDouble());
                    break;
                }
                case BOOLEAN: {
                    DefaultTransformV1Function.emit(nameKeys, attrAsName, labels, names, sample, output, value.asBoolean() ? 1.0 : 0.0);
                    break;
                }
            }
        }
    }

    private static void emit(List<String> nameKeys, boolean attrAsName, List<IndexLabel> labels, List<String> names, JsonSample sample, PathOutput output, double value) {
        try {
            HashMap<String, JsonNode> metricLabels = Maps.newHashMapWithExpectedSize(labels.size() + sample.properties.size());
            labels.forEach(label -> metricLabels.put(label.label, TextNode.valueOf(label.index)));
            sample.properties.forEach(metricLabels::put);
            StringBuilder nameBuilder = new StringBuilder();
            nameBuilder.append(sample.domain);
            for (String string : nameKeys) {
                nameBuilder.append(":");
                nameBuilder.append(((JsonNode)metricLabels.get(string)).asText());
            }
            StringBuilder attributeNameBuilder = new StringBuilder();
            attributeNameBuilder.append(sample.attribute);
            for (String name : names) {
                if (name == null) continue;
                attributeNameBuilder.append("_");
                attributeNameBuilder.append(name);
            }
            for (String nameKey : nameKeys) {
                metricLabels.remove(nameKey);
            }
            if (attrAsName) {
                nameBuilder.append(":");
                nameBuilder.append((CharSequence)attributeNameBuilder);
            } else {
                metricLabels.put("attribute", TextNode.valueOf(attributeNameBuilder.toString()));
            }
            HashMap<String, JsonNode> hashMap = Maps.newHashMapWithExpectedSize(3);
            hashMap.put("name", TextNode.valueOf(nameBuilder.toString()));
            hashMap.put("value", DoubleNode.valueOf(value));
            hashMap.put("labels", new ObjectNode(MAPPER.getNodeFactory(), metricLabels));
            output.emit(new ObjectNode(MAPPER.getNodeFactory(), hashMap), null);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static void transform(List<String> nameKeys, boolean attrAsName, JsonNode in, PathOutput output) throws JsonQueryException {
        JsonSample value = JsonSample.fromJsonNode(in);
        try {
            DefaultTransformV1Function.unfold(nameKeys, attrAsName, value, output);
        }
        catch (Exception e) {
            throw new JsonQueryException(e);
        }
    }

    private static class IndexLabel {
        public final String label;
        public final String index;

        public IndexLabel(String label, String index) {
            this.label = label;
            this.index = index;
        }
    }
}

