/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.org.joni.ast;

import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.ast.Node;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.exception.InternalException;

public final class ListNode
extends Node {
    public Node value;
    public ListNode tail;

    private ListNode(Node value, ListNode tail, int type) {
        super(type);
        this.value = value;
        if (value != null) {
            value.parent = this;
        }
        this.tail = tail;
        if (tail != null) {
            tail.parent = this;
        }
    }

    public static ListNode newAlt(Node value, ListNode tail) {
        return new ListNode(value, tail, 9);
    }

    public static ListNode newList(Node value, ListNode tail) {
        return new ListNode(value, tail, 8);
    }

    public static ListNode listAdd(ListNode list, Node value) {
        ListNode n = ListNode.newList(value, null);
        if (list != null) {
            while (list.tail != null) {
                list = list.tail;
            }
            list.setTail(n);
        }
        return n;
    }

    public void toListNode() {
        this.type = 8;
    }

    @Override
    protected void setChild(Node child) {
        this.value = child;
    }

    @Override
    protected Node getChild() {
        return this.value;
    }

    public void setValue(Node value) {
        this.value = value;
        value.parent = this;
    }

    public void setTail(ListNode tail) {
        this.tail = tail;
    }

    @Override
    public String getName() {
        switch (this.type) {
            case 9: {
                return "Alt";
            }
            case 8: {
                return "List";
            }
        }
        throw new InternalException("internal parser error (bug)");
    }

    @Override
    public String toString(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n  value: " + ListNode.pad(this.value, level + 1));
        sb.append("\n  tail: " + (this.tail == null ? "NULL" : this.tail.toString()));
        return sb.toString();
    }
}

