/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.org.joni;

import net.thisptr.java.prometheus.metrics.agent.shade.org.jcodings.Encoding;
import net.thisptr.java.prometheus.metrics.agent.shade.org.jcodings.IntHolder;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.exception.ErrorMessages;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.exception.InternalException;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.exception.SyntaxException;
import net.thisptr.java.prometheus.metrics.agent.shade.org.joni.exception.ValueException;

abstract class ScannerSupport
extends IntHolder
implements ErrorMessages {
    protected final Encoding enc;
    protected final byte[] bytes;
    protected int p;
    protected int stop;
    private int lastFetched;
    protected int c;
    private final int begin;
    private final int end;
    protected int _p;
    private static final int INT_SIGN_BIT = Integer.MIN_VALUE;

    protected ScannerSupport(Encoding enc, byte[] bytes, int p, int end) {
        this.enc = enc;
        this.bytes = bytes;
        this.begin = p;
        this.end = end;
    }

    protected final int getBegin() {
        return this.begin;
    }

    protected final int getEnd() {
        return this.end;
    }

    protected final int scanUnsignedNumber() {
        int last = this.c;
        int num = 0;
        while (this.left()) {
            this.fetch();
            if (this.enc.isDigit(this.c)) {
                int onum = num;
                if (((onum ^ (num = num * 10 + Encoding.digitVal(this.c))) & Integer.MIN_VALUE) == 0) continue;
                return -1;
            }
            this.unfetch();
            break;
        }
        this.c = last;
        return num;
    }

    protected final int scanUnsignedHexadecimalNumber(int minLength, int maxLength) {
        int last = this.c;
        int num = 0;
        int restLen = maxLength - minLength;
        while (this.left() && maxLength-- != 0) {
            this.fetch();
            if (this.enc.isXDigit(this.c)) {
                int val = this.enc.xdigitVal(this.c);
                if ((Integer.MAX_VALUE - val) / 16 < num) {
                    return -1;
                }
                num = (num << 4) + val;
                continue;
            }
            this.unfetch();
            ++maxLength;
            break;
        }
        if (maxLength > restLen) {
            return -2;
        }
        this.c = last;
        return num;
    }

    protected final int scanUnsignedOctalNumber(int maxLength) {
        int last = this.c;
        int num = 0;
        while (this.left() && maxLength-- != 0) {
            this.fetch();
            if (this.enc.isDigit(this.c) && this.c < 56) {
                int onum = num;
                int val = Encoding.odigitVal(this.c);
                if (((onum ^ (num = (num << 3) + val)) & Integer.MIN_VALUE) == 0) continue;
                return -1;
            }
            this.unfetch();
            break;
        }
        this.c = last;
        return num;
    }

    protected final void reset() {
        this.p = this.begin;
        this.stop = this.end;
    }

    protected final void mark() {
        this._p = this.p;
    }

    protected final void restore() {
        this.p = this._p;
    }

    protected final void inc() {
        this.lastFetched = this.p;
        this.p += this.enc.length(this.bytes, this.p, this.stop);
    }

    protected final void fetch() {
        this.c = this.enc.mbcToCode(this.bytes, this.p, this.stop);
        this.lastFetched = this.p;
        this.p += this.enc.length(this.bytes, this.p, this.stop);
    }

    protected int fetchTo() {
        int to = this.enc.mbcToCode(this.bytes, this.p, this.stop);
        this.lastFetched = this.p;
        this.p += this.enc.length(this.bytes, this.p, this.stop);
        return to;
    }

    protected final void unfetch() {
        this.p = this.lastFetched;
    }

    protected final int peek() {
        return this.p < this.stop ? this.enc.mbcToCode(this.bytes, this.p, this.stop) : 0;
    }

    protected final boolean peekIs(int c) {
        return this.peek() == c;
    }

    protected final boolean left() {
        return this.p < this.stop;
    }

    protected void newSyntaxException(String message) {
        throw new SyntaxException(message);
    }

    protected void newValueException(String message) {
        throw new ValueException(message);
    }

    protected void newValueException(String message, String str) {
        throw new ValueException(message, str);
    }

    protected void newValueException(String message, int p, int end) {
        throw new ValueException(message, new String(this.bytes, p, end - p));
    }

    protected void newInternalException(String message) {
        throw new InternalException(message);
    }
}

