/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.constraintvalidators.bv.size;

import java.lang.invoke.MethodHandles;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.ConstraintValidator;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.ConstraintValidatorContext;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.constraints.Size;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.util.logging.Log;
import net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.util.logging.LoggerFactory;

public class SizeValidatorForArray
implements ConstraintValidator<Size, Object[]> {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private int min;
    private int max;

    @Override
    public void initialize(Size parameters) {
        this.min = parameters.min();
        this.max = parameters.max();
        this.validateParameters();
    }

    @Override
    public boolean isValid(Object[] array, ConstraintValidatorContext constraintValidatorContext) {
        if (array == null) {
            return true;
        }
        return array.length >= this.min && array.length <= this.max;
    }

    private void validateParameters() {
        if (this.min < 0) {
            throw LOG.getMinCannotBeNegativeException();
        }
        if (this.max < 0) {
            throw LOG.getMaxCannotBeNegativeException();
        }
        if (this.max < this.min) {
            throw LOG.getLengthCannotBeNegativeException();
        }
    }
}

