/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.org.hibernate.validator.internal.constraintvalidators.bv;

import java.math.BigDecimal;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.ConstraintValidator;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.ConstraintValidatorContext;
import net.thisptr.java.prometheus.metrics.agent.shade.javax.validation.constraints.Max;

public class MaxValidatorForCharSequence
implements ConstraintValidator<Max, CharSequence> {
    private BigDecimal maxValue;

    @Override
    public void initialize(Max maxValue) {
        this.maxValue = BigDecimal.valueOf(maxValue.value());
    }

    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        try {
            return new BigDecimal(value.toString()).compareTo(this.maxValue) != 1;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

