/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path;

import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.NullNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.TextNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.PathOutput;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.Range;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.UnicodeUtils;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.Path;

public class ArrayRangeIndexPath
implements Path {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public final JsonNode start;
    public final JsonNode end;
    private final Path parent;

    public static ArrayRangeIndexPath chainIfNotNull(Path parent, JsonNode start, JsonNode end) {
        if (parent == null) {
            return null;
        }
        return new ArrayRangeIndexPath(parent, start, end);
    }

    public ArrayRangeIndexPath(Path parent, JsonNode start, JsonNode end) {
        if (parent == null) {
            throw new NullPointerException("parent must not be null");
        }
        if (start == null) {
            throw new NullPointerException("start must not be null");
        }
        if (end == null) {
            throw new NullPointerException("end must not be null");
        }
        if (!start.isNumber() && !start.isNull()) {
            throw new IllegalArgumentException("start must be java null or json number");
        }
        if (!end.isNumber() && !end.isNull()) {
            throw new IllegalArgumentException("end must be java null or json number");
        }
        this.parent = parent;
        this.start = start;
        this.end = end;
    }

    @Override
    public JsonNode mutate(JsonNode in, Path.Mutation mutation, boolean makeParent) throws JsonQueryException {
        return this.parent.mutate(in, oldval -> ArrayRangeIndexPath.mutate(oldval, this.start, this.end, mutation), makeParent);
    }

    @Override
    public void toJsonNode(ArrayNode out) throws JsonQueryException {
        ObjectNode range = MAPPER.createObjectNode();
        range.set("start", this.start);
        range.set("end", this.end);
        this.parent.toJsonNode(out);
        out.add(range);
    }

    @Override
    public void get(JsonNode in, Path ipath, PathOutput output, boolean permissive) throws JsonQueryException {
        this.parent.get(in, ipath, (parent, ppath) -> ArrayRangeIndexPath.resolve(parent, ppath, output, this.start, this.end, permissive), permissive);
    }

    private static JsonNode mutate(JsonNode in, JsonNode start, JsonNode end, Path.Mutation mutation) throws JsonQueryException {
        assert (start.isNull() || start.isNumber());
        assert (end.isNull() || end.isNumber());
        if (in == null) {
            in = NullNode.getInstance();
        }
        if (in.isArray()) {
            Range r = Range.resolve(start, end, in.size());
            ArrayNode out = MAPPER.createArrayNode();
            int index = 0;
            while ((long)index < r.start) {
                out.add(in.get(index));
                ++index;
            }
            ArrayNode oldval = MAPPER.createArrayNode();
            for (long index2 = r.start; index2 < r.end; ++index2) {
                oldval.add(in.get((int)index2));
            }
            JsonNode newval = mutation.apply(oldval);
            if (!newval.isArray()) {
                throw new JsonQueryTypeException("A slice of an array can only be assigned another array");
            }
            for (JsonNode element : newval) {
                out.add(element);
            }
            for (long index3 = r.end; index3 < (long)in.size(); ++index3) {
                out.add(in.get((int)index3));
            }
            return out;
        }
        if (in.isTextual()) {
            throw new JsonQueryException("Cannot update field at object index of string");
        }
        if (in.isNull()) {
            JsonNode newval = mutation.apply(NullNode.getInstance());
            if (!newval.isArray()) {
                throw new JsonQueryTypeException("A slice of an array can only be assigned another array");
            }
            return newval;
        }
        throw new JsonQueryTypeException("Cannot index %s with object", new Object[]{in.getNodeType()});
    }

    public static void resolve(JsonNode pobj, Path ppath, PathOutput output, JsonNode start, JsonNode end, boolean permissive) throws JsonQueryException {
        assert (start.isNull() || start.isNumber());
        assert (end.isNull() || end.isNumber());
        if (pobj.isArray()) {
            Range r = Range.resolve(start, end, pobj.size());
            ArrayNode subarray = MAPPER.createArrayNode();
            for (long index = r.start; index < r.end; ++index) {
                subarray.add(pobj.get((int)index));
            }
            output.emit(subarray, ArrayRangeIndexPath.chainIfNotNull(ppath, start, end));
        } else if (pobj.isTextual()) {
            Range r = Range.resolve(start, end, UnicodeUtils.lengthUtf32(pobj.textValue()));
            TextNode substring = new TextNode(UnicodeUtils.substringUtf32(pobj.textValue(), (int)r.start, (int)r.end));
            output.emit(substring, ArrayRangeIndexPath.chainIfNotNull(ppath, start, end));
        } else if (pobj.isNull()) {
            output.emit(NullNode.getInstance(), ArrayRangeIndexPath.chainIfNotNull(ppath, start, end));
        } else if (!permissive) {
            throw new JsonQueryTypeException("Cannot index %s with object", new Object[]{pobj.getNodeType()});
        }
    }
}

