/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path;

import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.ObjectMapper;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.IntNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.NullNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.PathOutput;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.Path;

public class ArrayIndexPath
implements Path {
    public final JsonNode index;
    private final Path parent;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static ArrayIndexPath chainIfNotNull(Path parent, int index) {
        return ArrayIndexPath.chainIfNotNull(parent, IntNode.valueOf(index));
    }

    public static ArrayIndexPath chainIfNotNull(Path parent, JsonNode index) {
        if (parent == null) {
            return null;
        }
        return new ArrayIndexPath(parent, index);
    }

    public ArrayIndexPath(Path parent, JsonNode index) {
        if (parent == null) {
            throw new NullPointerException("parent must not be null");
        }
        this.parent = parent;
        if (index == null) {
            throw new NullPointerException("index must not be null");
        }
        if (!index.isNumber()) {
            throw new IllegalArgumentException("index must be a number");
        }
        this.index = index;
    }

    @Override
    public void toJsonNode(ArrayNode out) throws JsonQueryException {
        this.parent.toJsonNode(out);
        out.add(this.index);
    }

    @Override
    public void get(JsonNode in, Path ipath, PathOutput output, boolean permissive) throws JsonQueryException {
        this.parent.get(in, ipath, (parent, ppath) -> ArrayIndexPath.resolve(parent, ppath, output, this.index, permissive), permissive);
    }

    @Override
    public JsonNode mutate(JsonNode in, Path.Mutation mutation, boolean makeParent) throws JsonQueryException {
        return this.parent.mutate(in, oldval -> ArrayIndexPath.mutate(oldval, this.index, mutation, makeParent, !makeParent), makeParent);
    }

    private static JsonNode mutate(JsonNode in, JsonNode index, Path.Mutation mutation, boolean makeParent, boolean deleteMode) throws JsonQueryException {
        assert (index.isNumber());
        if (in == null || in.isNull()) {
            if (!makeParent) {
                return in;
            }
            in = MAPPER.createArrayNode();
        }
        if (in.isArray()) {
            int i;
            int _index;
            int indexAsInt = index.asInt();
            int n = _index = indexAsInt < 0 ? indexAsInt + in.size() : indexAsInt;
            if (deleteMode && (_index < 0 || in.size() <= _index)) {
                return in;
            }
            if (_index < 0) {
                throw new JsonQueryException("Out of bounds negative array index");
            }
            JsonNode newval = mutation.apply(_index < in.size() ? in.get(_index) : null);
            if (newval == null) {
                return in;
            }
            ArrayNode out = MAPPER.createArrayNode();
            for (i = 0; i < in.size(); ++i) {
                out.add(in.get(i));
            }
            for (i = in.size(); i <= _index; ++i) {
                out.add(NullNode.getInstance());
            }
            out.set(_index, newval);
            return out;
        }
        throw new JsonQueryTypeException("Cannot index %s with number", new Object[]{in.getNodeType()});
    }

    public static void resolve(JsonNode pobj, Path ppath, PathOutput output, JsonNode index, boolean permissive) throws JsonQueryException {
        assert (index.isNumber());
        if (pobj.isArray()) {
            int indexResolved;
            int indexAsInt = index.asInt();
            if (index.asDouble() != (double)indexAsInt) {
                output.emit(NullNode.getInstance(), ArrayIndexPath.chainIfNotNull(ppath, index));
                return;
            }
            int n = indexResolved = indexAsInt < 0 ? indexAsInt + pobj.size() : indexAsInt;
            if (indexResolved < 0 || pobj.size() <= indexResolved) {
                output.emit(NullNode.getInstance(), ArrayIndexPath.chainIfNotNull(ppath, index));
                return;
            }
            output.emit(pobj.get(indexResolved), ArrayIndexPath.chainIfNotNull(ppath, index));
        } else if (pobj.isNull()) {
            output.emit(NullNode.getInstance(), ArrayIndexPath.chainIfNotNull(ppath, index));
        } else if (!permissive) {
            throw new JsonQueryTypeException("Cannot index %s with number", new Object[]{pobj.getNodeType()});
        }
    }
}

