/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree.matcher.matchers;

import java.util.List;
import java.util.Stack;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.java.prometheus.metrics.agent.shade.com.fasterxml.jackson.databind.node.NullNode;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Expression;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.Scope;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.Functional;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.misc.Pair;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.internal.tree.matcher.PatternMatcher;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.ObjectFieldPath;
import net.thisptr.java.prometheus.metrics.agent.shade.net.thisptr.jackson.jq.path.Path;

public class ObjectMatcher
implements PatternMatcher {
    private List<Pair<Expression, PatternMatcher>> matchers;

    public ObjectMatcher(List<Pair<Expression, PatternMatcher>> matchers) {
        this.matchers = matchers;
    }

    private void recursive(Scope scope, JsonNode in, Functional.Consumer<List<Pair<String, JsonNode>>> out, Stack<Pair<String, JsonNode>> accumulate, boolean emit, int index) throws JsonQueryException {
        if (index >= this.matchers.size()) {
            return;
        }
        Pair<Expression, PatternMatcher> kvexpr = this.matchers.get(index);
        Expression keyexpr = (Expression)kvexpr._1;
        PatternMatcher matcher = (PatternMatcher)kvexpr._2;
        keyexpr.apply(scope, in, key -> {
            if (!key.isTextual()) {
                throw new JsonQueryTypeException("Cannot index %s with %s", new Object[]{in.getNodeType(), key.getNodeType()});
            }
            JsonNode value = in.get(key.asText());
            int size = accumulate.size();
            matcher.match(scope, value != null ? value : NullNode.getInstance(), out, accumulate, emit && index == this.matchers.size() - 1);
            this.recursive(scope, in, out, accumulate, emit, index + 1);
            accumulate.setSize(size);
        });
    }

    private void recursiveWithPath(Scope scope, JsonNode in, Path inpath, PatternMatcher.MatchOutput output, Stack<PatternMatcher.MatchWithPath> accumulate, boolean emit, int index) throws JsonQueryException {
        if (index >= this.matchers.size()) {
            return;
        }
        Pair<Expression, PatternMatcher> kvexpr = this.matchers.get(index);
        Expression keyexpr = (Expression)kvexpr._1;
        PatternMatcher matcher = (PatternMatcher)kvexpr._2;
        keyexpr.apply(scope, in, key -> {
            if (!key.isTextual()) {
                throw new JsonQueryTypeException("Cannot index %s with %s", new Object[]{in.getNodeType(), key.getNodeType()});
            }
            JsonNode value = in.get(key.asText());
            ObjectFieldPath valuepath = ObjectFieldPath.chainIfNotNull(inpath, key.asText());
            int size = accumulate.size();
            matcher.matchWithPath(scope, value != null ? value : NullNode.getInstance(), valuepath, output, accumulate, emit && index == this.matchers.size() - 1);
            this.recursiveWithPath(scope, in, inpath, output, accumulate, emit, index + 1);
            accumulate.setSize(size);
        });
    }

    @Override
    public void match(Scope scope, JsonNode in, Functional.Consumer<List<Pair<String, JsonNode>>> out, Stack<Pair<String, JsonNode>> accumulate, boolean emit) throws JsonQueryException {
        if (!in.isObject() && !in.isNull()) {
            throw new JsonQueryTypeException("Cannot index %s with string", new Object[]{in.getNodeType()});
        }
        this.recursive(scope, in, out, accumulate, emit, 0);
    }

    @Override
    public void matchWithPath(Scope scope, JsonNode in, Path path, PatternMatcher.MatchOutput output, Stack<PatternMatcher.MatchWithPath> accumulate, boolean emit) throws JsonQueryException {
        if (!in.isObject() && !in.isNull()) {
            throw new JsonQueryTypeException("Cannot index %s with string", new Object[]{in.getNodeType()});
        }
        this.recursiveWithPath(scope, in, path, output, accumulate, emit, 0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        String sep = "";
        for (Pair<Expression, PatternMatcher> entry : this.matchers) {
            sb.append(sep);
            sb.append(entry._1);
            sb.append(": ");
            sb.append(entry._2);
            sep = ", ";
        }
        sb.append("}");
        return sb.toString();
    }
}

